/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.admin.management;

import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.nuxeo.common.Environment;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.admin.management.BundleResource;
import org.nuxeo.ecm.webengine.admin.management.ComponentResource;
import org.nuxeo.ecm.webengine.admin.management.RootContainerResource;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.view.TemplateView;
import org.nuxeo.runtime.RuntimeService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.RegistrationInfo;
import org.nuxeo.runtime.osgi.OSGiRuntimeService;
import org.osgi.framework.Bundle;

@Path(value="server")
public class ServerManagement {
    public static final String ACTIVATION_PROPERTY = "org.nuxeo.runtime.rest.management";

    public ServerManagement() {
        this.checkActivation();
    }

    @GET
    @Produces(value={"application/atomsvc+xml"})
    public Object getServiceDocument() {
        return new TemplateView((Object)this, "servicedoc.ftl");
    }

    @GET
    @Path(value="html")
    @Produces(value={"text/html"})
    public Object getServiceDocumentHtml() {
        return new TemplateView((Object)this, "servicedoc.html.ftl");
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="system_properties")
    public Object getSystemProperties() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            String value = entry.getValue() == null ? "" : entry.getValue().toString();
            sb.append(entry.getKey()).append("=").append(ServerManagement.formatPropertyValue(value)).append("\n");
        }
        return sb.toString();
    }

    @POST
    @Path(value="system_properties")
    public Response setSystemProperty(@QueryParam(value="key") String key, @QueryParam(value="value") String value) {
        System.setProperty(key, value);
        return Response.ok((Object)this.getSystemProperties()).build();
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="runtime_properties")
    public Object getRuntimeProperties() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Object, Object> entry : Framework.getProperties().entrySet()) {
            String value = entry.getValue() == null ? "" : entry.getValue().toString();
            sb.append(entry.getKey()).append("=").append(ServerManagement.formatPropertyValue(value)).append("\n");
        }
        return sb.toString();
    }

    @POST
    @Path(value="runtime_properties")
    public Response setRuntimeProperty(@QueryParam(value="key") String key, @QueryParam(value="value") String value) {
        Framework.getProperties().put(key, value);
        return Response.ok((Object)this.getRuntimeProperties()).build();
    }

    @GET
    @Path(value="bundles")
    @Produces(value={"application/atom+xml"})
    public Object getBundles() {
        if (Framework.getRuntime() instanceof OSGiRuntimeService) {
            OSGiRuntimeService runtime = (OSGiRuntimeService)Framework.getRuntime();
            Bundle[] bundles = runtime.getBundleContext().getBundles();
            return new TemplateView((Object)this, "bundles.ftl").arg("bundles", (Object)bundles);
        }
        return Response.status((int)410);
    }

    @GET
    @Path(value="components")
    @Produces(value={"application/atom+xml"})
    public Object getComponents() {
        Collection regs = Framework.getRuntime().getComponentManager().getRegistrations();
        return new TemplateView((Object)this, "components.ftl").arg("components", (Object)regs);
    }

    @POST
    @Path(value="components")
    public Response postComponent() {
        try {
            ServletInputStream in = WebEngine.getActiveContext().getRequest().getInputStream();
            byte[] bytes = FileUtils.readBytes((InputStream)in);
            System.out.println("Deploying component:\n-----------------------------\n" + new String(bytes) + "\n------------------------------");
            ((OSGiRuntimeService)Framework.getRuntime()).getComponentPersistence().createComponent(bytes);
        }
        catch (Exception e) {
            throw WebException.wrap((String)"Failed to create component", (Throwable)e);
        }
        return null;
    }

    @Path(value="components/{name}")
    public ComponentResource getComponent(@PathParam(value="name") String name) {
        RegistrationInfo ri = Framework.getRuntime().getComponentManager().getRegistrationInfo(new ComponentName(name));
        return new ComponentResource(ri);
    }

    @POST
    @Path(value="bundles")
    public Response installBundle() {
        return null;
    }

    @Path(value="bundles/{symbolicName}")
    public BundleResource getBundle(@PathParam(value="symbolicName") String name) {
        OSGiRuntimeService runtime = (OSGiRuntimeService)Framework.getRuntime();
        for (Bundle bundle : runtime.getBundleContext().getBundles()) {
            if (!bundle.getSymbolicName().equals(name)) continue;
            return new BundleResource(bundle);
        }
        throw new WebResourceNotFoundException("No such bundle: " + name);
    }

    @Path(value="resources")
    public Object getResources() {
        Environment env = Environment.getDefault();
        return new RootContainerResource(new File(env.getData(), "resources"));
    }

    public RuntimeService getRuntime() {
        return Framework.getRuntime();
    }

    public Environment getEnvironment() {
        return Environment.getDefault();
    }

    public String getComponentSummary(RegistrationInfo ri) {
        return ri.getDocumentation();
    }

    public String getBundleHeader(Bundle bundle, String key) {
        return (String)bundle.getHeaders().get(key);
    }

    public String getBundleFileName(Bundle bundle) {
        return Framework.getRuntime().getBundleFile(bundle).getName();
    }

    public static String formatPropertyValue(String value) {
        int k = value.indexOf(10);
        if (k == -1) {
            return value;
        }
        StringBuilder buf = new StringBuilder();
        if (k > 0 && value.charAt(k - 1) == '\r') {
            buf.append(value.substring(0, k - 1)).append('\\').append("\r\n");
        } else {
            buf.append(value.substring(0, k)).append('\\').append('\n');
        }
        char[] chars = value.toCharArray();
        boolean cr = false;
        block4: for (int i = k + 1; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case '\r': {
                    buf.append('\\').append(c);
                    cr = true;
                    continue block4;
                }
                case '\n': {
                    if (!cr) {
                        buf.append('\\').append(c);
                    }
                    cr = false;
                    continue block4;
                }
                default: {
                    cr = false;
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    protected void checkActivation() {
        if (!"true".equals(Framework.getProperty((String)ACTIVATION_PROPERTY, (String)"false"))) {
            throw new WebException(403);
        }
    }
}

