/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.admin;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.core.rest.DocumentRoot;
import org.nuxeo.ecm.webengine.model.Access;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.exceptions.WebSecurityException;
import org.nuxeo.ecm.webengine.model.impl.ModuleRoot;

@WebObject(type="Admin", administrator=Access.GRANT)
@Produces(value={"text/html;charset=UTF-8"})
@Path(value="/admin")
public class Main
extends ModuleRoot {
    @Path(value="users")
    public Object getUserManagement() {
        return this.newObject("UserManager", new Object[0]);
    }

    @Path(value="engine")
    public Object getEngine() {
        return this.newObject("Engine", new Object[0]);
    }

    @Path(value="repository")
    public Object getRepository() {
        return new DocumentRoot(this.ctx, "/");
    }

    @GET
    public Object getIndex() {
        return this.getView("index");
    }

    @GET
    @Path(value="help")
    public Object getHelp() {
        return this.getTemplate("help/help.ftl");
    }

    @GET
    @Path(value="about")
    public Object getAbout() {
        return this.getTemplate("help/about.ftl");
    }

    public Object handleError(WebApplicationException e) {
        if (e instanceof WebSecurityException) {
            return Response.status((int)401).entity((Object)this.getTemplate("error/error_401.ftl")).type("text/html").build();
        }
        if (e instanceof WebResourceNotFoundException) {
            return Response.status((int)404).entity((Object)this.getTemplate("error/error_404.ftl")).type("text/html").build();
        }
        return super.handleError(e);
    }
}

