/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.admin;

import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.usermanager.NuxeoPrincipalImpl;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="User")
@Produces(value={"text/html;charset=UTF-8"})
public class User
extends DefaultObject {
    NuxeoPrincipalImpl principal;

    protected void initialize(Object ... args) {
        assert (args != null && args.length > 0);
        this.principal = (NuxeoPrincipalImpl)args[0];
    }

    @GET
    public Object doGet() {
        return this.getView("index").arg("user", (Object)this.principal);
    }

    @POST
    public Response doPost() {
        return this.redirect(this.getPrevious().getPath());
    }

    @PUT
    public Response doPut() throws Exception {
        UserManager userManager = (UserManager)Framework.getService(UserManager.class);
        HttpServletRequest req = this.ctx.getRequest();
        this.principal.setFirstName(req.getParameter("firstName"));
        this.principal.setLastName(req.getParameter("lastName"));
        this.principal.setPassword(req.getParameter("password"));
        this.principal.setEmail(req.getParameter("email"));
        String[] selectedGroups = req.getParameterValues("groups");
        List<String> listGroups = Arrays.asList(selectedGroups);
        this.principal.setGroups(listGroups);
        userManager.updatePrincipal((NuxeoPrincipal)this.principal);
        return this.redirect(this.getPath());
    }

    @DELETE
    public Response doDelete() throws Exception {
        UserManager userManager = (UserManager)Framework.getService(UserManager.class);
        userManager.deletePrincipal((NuxeoPrincipal)this.principal);
        return this.redirect(this.getPrevious().getPath());
    }

    @POST
    @Path(value="@put")
    public Response simulatePut() throws Exception {
        return this.doPut();
    }

    @GET
    @Path(value="@delete")
    public Response simulateDelete() throws Exception {
        return this.doDelete();
    }
}

