/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.webengine.blogs;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.model.Resource;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.webengine.sites.Site;

@WebObject(type="BlogSite", facets={"BlogSite"})
@Produces(value={"text/html;charset=UTF-8"})
public class BlogSite
extends Site {
    @Path(value="{path}")
    public Resource traverse(@PathParam(value="path") String path) {
        return super.traverse(path);
    }

    protected String getDefaultSchemaFieldThemeValue() {
        return "blogs";
    }

    protected String getDefaultSchemaFieldThemePageValue() {
        return "site";
    }

    protected String getWebSiteDocumentType() {
        return "BlogSite";
    }

    protected String getWebPageDocumentType() {
        return "BlogPost";
    }

    protected String getSearchThemePage() {
        return "blogs/search";
    }

    public String getIdForRss() {
        return this.doc.getId();
    }

    protected void setSearchParameters() {
        super.setSearchParameters();
        String year = this.ctx.getRequest().getParameter("year");
        String month = this.ctx.getRequest().getParameter("month");
        if (year != null) {
            GregorianCalendar c = null;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd", WebEngine.getActiveContext().getLocale());
            if (month != null) {
                c = new GregorianCalendar(new Integer(year), new Integer(month) - 1, 1);
                this.ctx.setProperty("dateAfter", (Object)simpleDateFormat.format(c.getTime()));
                ((Calendar)c).add(2, 1);
                this.ctx.setProperty("dateBefore", (Object)simpleDateFormat.format(c.getTime()));
            } else {
                c = new GregorianCalendar(new Integer(year), 0, 1);
                this.ctx.setProperty("dateAfter", (Object)simpleDateFormat.format(c.getTime()));
                ((Calendar)c).add(1, 1);
                this.ctx.setProperty("dateBefore", (Object)simpleDateFormat.format(c.getTime()));
            }
        }
    }

    protected String getErrorTemplateName() {
        return "no_blog.ftl";
    }
}

