/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.gwt;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.Environment;

public class GwtResolver {
    private final Log log = LogFactory.getLog(GwtResolver.class);
    public final File GWT_ROOT = GwtResolver.locateRoot();
    protected final Map<String, CompositeStrategy> strategies = new HashMap<String, CompositeStrategy>();
    protected final Strategy ROOT_RESOLVER_STRATEGY = new Strategy(){

        @Override
        public URI source() {
            return GwtResolver.this.GWT_ROOT.toURI();
        }

        @Override
        public File resolve(String path) {
            return new File(GwtResolver.this.GWT_ROOT, path);
        }
    };

    private static File locateRoot() {
        File dir = new File(Environment.getDefault().getWeb(), "root.war/gwt");
        dir.mkdirs();
        return dir;
    }

    public Strategy newStrategy(final URI location) throws IOException {
        final File root = this.install(location);
        return new Strategy(){

            @Override
            public URI source() {
                return location;
            }

            @Override
            public File resolve(String path) {
                return new File(root, path);
            }
        };
    }

    /*
     * Loose catch block
     */
    protected File install(URI location) throws IOException {
        block19: {
            if (!"jar".equals(location.getScheme())) break block19;
            Map env = Collections.emptyMap();
            Throwable throwable = null;
            try (FileSystem fileSystem = FileSystems.newFileSystem(location, env, this.getClass().getClassLoader());){
                Path path = Paths.get(location);
                try {
                    File file = path.toFile();
                    return file;
                }
                catch (UnsupportedOperationException cause) {
                    File file;
                    block17: {
                        block18: {
                            Files.walkFileTree(path, new TreeImporter(path, this.GWT_ROOT.toPath()));
                            file = this.GWT_ROOT;
                            if (fileSystem == null) break block17;
                            if (throwable == null) break block18;
                            try {
                                fileSystem.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            break block17;
                        }
                        fileSystem.close();
                    }
                    return file;
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throw throwable3;
                    }
                }
            }
        }
        return Paths.get(location).toFile();
    }

    public void install(String name, Strategy strategy) {
        if (!this.strategies.containsKey(name)) {
            this.strategies.put(name, new CompositeStrategy());
        }
        this.strategies.get(name).install(strategy);
    }

    public void install(String name, URI location) throws IOException {
        this.install(name, this.newStrategy(location));
    }

    public void uninstall(String name) {
        this.strategies.remove(name);
    }

    public File resolve(String path) {
        int indexOf = path.indexOf(47);
        if (indexOf == -1) {
            if (this.strategies.containsKey(path)) {
                return this.strategies.get(path).resolve("/");
            }
            return this.ROOT_RESOLVER_STRATEGY.resolve(path);
        }
        String name = path.substring(0, indexOf);
        if (this.strategies.containsKey(name)) {
            return this.strategies.get(name).resolve(path);
        }
        return this.ROOT_RESOLVER_STRATEGY.resolve(path);
    }

    public class TreeImporter
    implements FileVisitor<Path> {
        final Path source;
        final Path sink;

        public TreeImporter(Path source, Path sink) {
            this.source = source;
            this.sink = sink;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            if (dir == this.source) {
                return FileVisitResult.CONTINUE;
            }
            Path sinkPath = this.toSinkPath(dir);
            if (!Files.exists(sinkPath, new LinkOption[0])) {
                Files.createDirectory(sinkPath, new FileAttribute[0]);
            }
            return FileVisitResult.CONTINUE;
        }

        Path toSinkPath(Path path) {
            if (path == this.source) {
                return this.sink;
            }
            path = this.source.relativize(path);
            path = this.sink.resolve(path.toString());
            return path;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.copy(file, this.toSinkPath(file), StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException error) {
            if (error != null) {
                return FileVisitResult.TERMINATE;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException error) {
            if (error != null) {
                return FileVisitResult.TERMINATE;
            }
            return FileVisitResult.CONTINUE;
        }
    }

    class CompositeStrategy {
        final Map<URI, Strategy> strategiesByKey = new HashMap<URI, Strategy>();
        final List<Strategy> strategies = new ArrayList<Strategy>();

        CompositeStrategy() {
        }

        void install(Strategy strategy) {
            this.strategiesByKey.put(strategy.source(), strategy);
            this.strategies.add(strategy);
        }

        void uninstall(URI source) {
            Strategy strategy = this.strategiesByKey.remove(source);
            if (strategy == null) {
                return;
            }
            this.strategies.remove(strategy);
        }

        public File resolve(String path) {
            ListIterator<Strategy> it = this.strategies.listIterator(this.strategies.size());
            while (it.hasPrevious()) {
                File file = it.previous().resolve(path);
                if (!file.exists()) continue;
                return file;
            }
            return null;
        }
    }

    public static interface Strategy {
        public URI source();

        public File resolve(String var1);
    }
}

