/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.jaxrs.context;

import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nuxeo.ecm.webengine.jaxrs.context.RequestCleanupHandler;

public class RequestContext
extends HashMap<String, Object> {
    private static final long serialVersionUID = 1L;
    private static final ThreadLocal<RequestContext> CTX = new ThreadLocal();
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    protected List<RequestCleanupHandler> cleanupHandlers;

    public static RequestContext getActiveContext() {
        return CTX.get();
    }

    public static RequestContext getActiveContext(ServletRequest request) {
        return (RequestContext)request.getAttribute(RequestContext.class.getName());
    }

    public RequestContext(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
        this.cleanupHandlers = new ArrayList<RequestCleanupHandler>();
        CTX.set(this);
        request.setAttribute(RequestContext.class.getName(), (Object)this);
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public Principal getUserPrincipal() {
        return this.request.getUserPrincipal();
    }

    public <T> T get(String key, Class<T> type) {
        Object o = this.get(key);
        return (T)o;
    }

    public void addRequestCleanupHandler(RequestCleanupHandler handler) {
        this.cleanupHandlers.add(handler);
    }

    public boolean removeCleanupHandler(RequestCleanupHandler handler) {
        return this.cleanupHandlers.remove(handler);
    }

    public void dispose() {
        this.request.removeAttribute(RequestContext.class.getName());
        CTX.remove();
        Throwable suppressed = null;
        for (RequestCleanupHandler handler : this.cleanupHandlers) {
            try {
                handler.cleanup(this.request);
            }
            catch (RuntimeException e) {
                if (suppressed == null) {
                    suppressed = new RuntimeException("Exceptions during cleanup");
                }
                suppressed.addSuppressed(e);
            }
        }
        this.cleanupHandlers = null;
        this.request = null;
        this.response = null;
        if (suppressed != null) {
            throw suppressed;
        }
    }
}

