/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.jaxrs.servlet;

import com.sun.jersey.api.uri.UriBuilderImpl;
import com.sun.jersey.server.impl.provider.RuntimeDelegateImpl;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.nuxeo.ecm.webengine.jaxrs.Activator;
import org.nuxeo.ecm.webengine.jaxrs.servlet.CompoundEnumeration;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class ServiceClassLoader
extends ClassLoader {
    protected Bundle bundle;
    protected List<ClassLoader> loaders;

    public static ClassLoader getLoader() {
        BundleContext ctx = Activator.getInstance().getContext();
        String vendor = ctx.getProperty("org.osgi.framework.vendor");
        if (vendor != null && vendor.contains("Nuxeo")) {
            return Activator.class.getClassLoader();
        }
        ServiceClassLoader loader = new ServiceClassLoader(ctx.getBundle());
        loader.addResourceLoader(RuntimeDelegateImpl.class.getClassLoader());
        loader.addResourceLoader(UriBuilderImpl.class.getClassLoader());
        return loader;
    }

    public ServiceClassLoader(Bundle bundle) {
        this.bundle = bundle;
        this.loaders = new ArrayList<ClassLoader>();
    }

    public void addResourceLoader(ClassLoader cl) {
        this.loaders.add(cl);
    }

    @Override
    protected URL findResource(String name) {
        ClassLoader cl;
        URL url = null;
        Iterator<ClassLoader> iterator = this.loaders.iterator();
        while (iterator.hasNext() && (url = (cl = iterator.next()).getResource(name)) == null) {
        }
        return url;
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        ArrayList<Enumeration<URL>> enums = new ArrayList<Enumeration<URL>>();
        for (ClassLoader cl : this.loaders) {
            enums.add(cl.getResources(name));
        }
        return new CompoundEnumeration<URL>(enums.toArray(new Enumeration[enums.size()]));
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return this.bundle.loadClass(name);
    }
}

