/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.jaxrs.servlet.mapping;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.webengine.jaxrs.servlet.mapping.ExactSegmentMatcher;
import org.nuxeo.ecm.webengine.jaxrs.servlet.mapping.Path;
import org.nuxeo.ecm.webengine.jaxrs.servlet.mapping.RegexSegmentMatcher;
import org.nuxeo.ecm.webengine.jaxrs.servlet.mapping.SegmentMatcher;
import org.nuxeo.ecm.webengine.jaxrs.servlet.mapping.WildcardSegmentMatcher;

public class PathMatcher {
    public static final PathMatcher ANY = new PathMatcher(new SegmentMatcher[0]);
    protected final SegmentMatcher[] matchers;

    public PathMatcher(SegmentMatcher ... matchers) {
        this.matchers = matchers;
    }

    public boolean matches(String path) {
        return this.matches(Path.parse(path));
    }

    public boolean matches(Path path) {
        if (this.matchers.length == 0) {
            return true;
        }
        return this.matches(path.segments, 0, 0);
    }

    public boolean matches(String[] segments, int soff, int moff) {
        if (soff == segments.length) {
            if (moff == this.matchers.length) {
                return true;
            }
            return moff == this.matchers.length - 1 && this.matchers[moff] == SegmentMatcher.ANY;
        }
        if (moff == this.matchers.length) {
            return this.matchers[moff - 1] == SegmentMatcher.ANY;
        }
        SegmentMatcher m = this.matchers[moff];
        if (m == SegmentMatcher.ANY) {
            for (int i = soff; i < segments.length; ++i) {
                if (!this.matches(segments, i, moff + 1)) continue;
                return true;
            }
            return false;
        }
        if (!m.matches(segments[soff])) {
            return false;
        }
        return this.matches(segments, soff + 1, moff + 1);
    }

    public static PathMatcher compile(String path) {
        return PathMatcher.compile(Path.parse(path));
    }

    public static PathMatcher compile(Path path) {
        ArrayList<SegmentMatcher> matchers = new ArrayList<SegmentMatcher>();
        for (String segment : path.segments) {
            if (segment.length() == 0) continue;
            if ("**".equals(segment)) {
                PathMatcher.addAnyMatcher(matchers, SegmentMatcher.ANY);
                continue;
            }
            if ("*".equals(segment)) {
                PathMatcher.addAnyMatcher(matchers, SegmentMatcher.ANY_SEGMENT);
                continue;
            }
            if (segment.charAt(0) == '(' && segment.charAt(segment.length() - 1) == ')') {
                matchers.add(new RegexSegmentMatcher(segment.substring(1, segment.length() - 1)));
                continue;
            }
            matchers.add(PathMatcher.createSegmentMatcher(segment));
        }
        return new PathMatcher(matchers.toArray(new SegmentMatcher[matchers.size()]));
    }

    private static void addAnyMatcher(List<SegmentMatcher> matchers, SegmentMatcher matcher) {
        if (!matchers.isEmpty() && matchers.get(matchers.size() - 1) == matcher) {
            return;
        }
        matchers.add(matcher);
    }

    private static SegmentMatcher createSegmentMatcher(String segment) {
        if (segment.indexOf(42) == -1 && segment.indexOf(63) == -1) {
            return new ExactSegmentMatcher(segment);
        }
        return new WildcardSegmentMatcher(segment);
    }

    public String toString() {
        if (this.matchers.length == 0) {
            return "/**";
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.matchers.length; ++i) {
            buf.append("/").append(this.matchers[i]);
        }
        return buf.toString();
    }
}

