/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.jaxrs.servlet.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import org.nuxeo.ecm.webengine.jaxrs.servlet.ServletHolder;
import org.nuxeo.ecm.webengine.jaxrs.servlet.config.BundleHttpContext;
import org.nuxeo.ecm.webengine.jaxrs.servlet.config.FilterSetDescriptor;
import org.nuxeo.ecm.webengine.jaxrs.servlet.config.ListenerSetDescriptor;
import org.nuxeo.ecm.webengine.jaxrs.servlet.config.ResourcesDescriptor;
import org.nuxeo.ecm.webengine.jaxrs.servlet.config.ServletDescriptor;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;

public class ServletRegistry {
    public static final String SERVLET_NAME = ServletRegistry.class.getName() + ".name";
    private static volatile ServletRegistry instance;
    protected List<ServletDescriptor> servlets = new ArrayList<ServletDescriptor>();
    protected List<FilterSetDescriptor> filters = new ArrayList<FilterSetDescriptor>();
    protected Map<String, List<ResourcesDescriptor>> resources = new HashMap<String, List<ResourcesDescriptor>>();
    protected Map<String, BundleHttpContext> contexts = new HashMap<String, BundleHttpContext>();
    protected HttpService service;
    protected Bundle bundle;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ServletRegistry getInstance() {
        ServletRegistry reg = instance;
        if (reg != null) return reg;
        Class<ServletRegistry> clazz = ServletRegistry.class;
        synchronized (ServletRegistry.class) {
            instance = reg = new ServletRegistry();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return reg;
        }
    }

    public static synchronized void dispose() {
        instance = null;
    }

    private ServletRegistry() {
    }

    public synchronized ServletDescriptor[] getServletDescriptors() {
        return this.servlets.toArray(new ServletDescriptor[this.servlets.size()]);
    }

    public synchronized FilterSetDescriptor[] getFilterSetDescriptors() {
        return this.filters.toArray(new FilterSetDescriptor[this.filters.size()]);
    }

    public ServletDescriptor getServletDescriptor(String name) {
        for (ServletDescriptor servlet : this.getServletDescriptors()) {
            if (!name.equals(servlet.name)) continue;
            return servlet;
        }
        return null;
    }

    public List<FilterSetDescriptor> getFiltersFor(String name) {
        ArrayList<FilterSetDescriptor> list = new ArrayList<FilterSetDescriptor>();
        for (FilterSetDescriptor filter : this.getFilterSetDescriptors()) {
            if (!name.equals(filter.targetServlet)) continue;
            list.add(filter);
        }
        return list;
    }

    public synchronized void initHttpService(HttpService service) throws Exception {
        if (this.service == null) {
            this.service = service;
            this.installServlets();
        }
    }

    public HttpService getHttpService() {
        return this.service;
    }

    public synchronized void addServlet(ServletDescriptor descriptor) throws Exception {
        this.servlets.add(descriptor);
        this.installServlet(descriptor);
    }

    public synchronized void removeServlet(ServletDescriptor descriptor) {
        this.servlets.remove(descriptor);
        this.contexts.remove(descriptor.path);
        if (this.service != null) {
            ListenerSetDescriptor lsd = descriptor.getListenerSet();
            if (lsd != null) {
                lsd.destroy();
            }
            this.service.unregister(descriptor.path);
        }
    }

    public synchronized void reloadServlet(ServletDescriptor descriptor) throws Exception {
        this.removeServlet(descriptor);
        this.addServlet(descriptor);
    }

    public synchronized void addFilterSet(FilterSetDescriptor filter) {
        this.filters.add(filter);
    }

    public synchronized void removeFilterSet(FilterSetDescriptor filter) {
        this.filters.remove(filter);
    }

    public synchronized void addResources(ResourcesDescriptor rd) {
        List<ResourcesDescriptor> list = this.resources.get(rd.getServlet());
        if (list == null) {
            list = new ArrayList<ResourcesDescriptor>();
        }
        list.add(rd);
        BundleHttpContext ctx = this.contexts.get(rd.getServlet());
        if (ctx != null) {
            ctx.setResources(list.toArray(new ResourcesDescriptor[list.size()]));
        }
    }

    public synchronized void removeResources(ResourcesDescriptor rd) {
        List<ResourcesDescriptor> list = this.resources.get(rd.getServlet());
        if (list != null && list.remove(rd)) {
            BundleHttpContext ctx;
            if (list.isEmpty()) {
                this.resources.remove(rd.getServlet());
            }
            if ((ctx = this.contexts.get(rd.getServlet())) != null) {
                ctx.setResources(list.toArray(new ResourcesDescriptor[list.size()]));
            }
        }
    }

    private synchronized void installServlets() throws Exception {
        if (this.service != null) {
            for (ServletDescriptor sd : this.servlets) {
                this.installServlet(sd);
            }
        }
    }

    private void installServlet(ServletDescriptor sd) throws Exception {
        if (this.service != null) {
            BundleHttpContext ctx = new BundleHttpContext(sd.bundle, sd.resources);
            List<ResourcesDescriptor> rd = this.resources.get(sd.path);
            if (rd != null) {
                ctx.setResources(rd.toArray(new ResourcesDescriptor[rd.size()]));
            }
            Hashtable<String, String> params = new Hashtable<String, String>();
            if (sd.name != null) {
                params.putAll(sd.getInitParams());
                params.put(SERVLET_NAME, sd.name);
            }
            this.service.registerServlet(sd.path, (Servlet)new ServletHolder(), params, (HttpContext)ctx);
            this.contexts.put(sd.path, ctx);
        }
    }
}

