/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.jaxrs.servlet;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import org.nuxeo.ecm.webengine.jaxrs.servlet.FilterSet;
import org.nuxeo.ecm.webengine.jaxrs.servlet.ManagedServlet;
import org.nuxeo.ecm.webengine.jaxrs.servlet.config.ServletDescriptor;
import org.nuxeo.ecm.webengine.jaxrs.servlet.mapping.Path;

public class RequestChain {
    protected HttpServlet servlet;
    protected FilterSet[] filters;

    public RequestChain(HttpServlet servlet, FilterSet[] filters) {
        if (servlet == null) {
            throw new IllegalArgumentException("No target servlet defined");
        }
        this.filters = filters == null ? new FilterSet[]{} : filters;
        this.servlet = servlet;
    }

    public FilterSet[] getFilters() {
        return this.filters;
    }

    public HttpServlet getServlet() {
        return this.servlet;
    }

    public void init(ServletDescriptor sd, ServletConfig config) throws ServletException {
        for (FilterSet filterSet : this.filters) {
            filterSet.init(config);
        }
        if (this.servlet instanceof ManagedServlet) {
            ((ManagedServlet)this.servlet).setDescriptor(sd);
        }
        this.servlet.init((ServletConfig)new ServletConfigAdapter(sd, config));
    }

    public void execute(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        if (this.filters.length == 0 || !(request instanceof HttpServletRequest)) {
            this.servlet.service(request, response);
            return;
        }
        String pathInfo = ((HttpServletRequest)request).getPathInfo();
        Path path = pathInfo == null || pathInfo.length() == 0 ? Path.ROOT : Path.parse(pathInfo);
        for (FilterSet filterSet : this.filters) {
            if (!filterSet.matches(path)) continue;
            new ServletFilterChain(this.servlet, filterSet.getFilters()).doFilter(request, response);
            return;
        }
        this.servlet.service(request, response);
    }

    public void destroy() {
        if (this.servlet != null) {
            this.servlet.destroy();
            this.servlet = null;
        }
        for (FilterSet filterSet : this.filters) {
            filterSet.destroy();
        }
        this.filters = null;
    }

    static class ServletConfigAdapter
    implements ServletConfig {
        protected final ServletConfig config;
        protected final ServletDescriptor sd;

        public ServletConfigAdapter(ServletDescriptor sd, ServletConfig config) {
            this.config = config;
            this.sd = sd;
        }

        public String getInitParameter(String key) {
            return this.sd.getInitParams().get(key);
        }

        public Enumeration<String> getInitParameterNames() {
            return Collections.enumeration(this.sd.getInitParams().keySet());
        }

        public ServletContext getServletContext() {
            return this.config.getServletContext();
        }

        public String getServletName() {
            return this.sd.getName();
        }
    }

    public static class ServletFilterChain
    implements FilterChain {
        protected final HttpServlet servlet;
        protected final Filter[] filters;
        protected int filterIndex;

        public ServletFilterChain(HttpServlet servlet, Filter[] filters) {
            this.servlet = servlet;
            this.filters = filters;
            this.filterIndex = 0;
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            if (this.filterIndex < this.filters.length) {
                Filter filter = this.filters[this.filterIndex++];
                filter.doFilter(request, response, (FilterChain)this);
            } else {
                this.servlet.service(request, response);
            }
        }
    }
}

