/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.management.statuses;

import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.nuxeo.ecm.core.management.api.AdministrativeStatus;
import org.nuxeo.ecm.core.management.api.AdministrativeStatusManager;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.forms.FormData;
import org.nuxeo.ecm.webengine.management.ManagementObject;
import org.nuxeo.ecm.webengine.model.Access;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="AdministrativeStatus", administrator=Access.GRANT)
@Produces(value={"text/html; charset=UTF-8"})
public class AdministrativeStatusObject
extends ManagementObject {
    protected AdministrativeStatus administrativeStatus;

    public static AdministrativeStatusObject newAdministrativeStatus(DefaultObject parent) {
        return (AdministrativeStatusObject)parent.newObject("AdministrativeStatus", new Object[0]);
    }

    public void initialize(Object ... args) {
        super.initialize(args);
        AdministrativeStatusManager mgr = (AdministrativeStatusManager)Framework.getLocalService(AdministrativeStatusManager.class);
        this.administrativeStatus = mgr.getNuxeoInstanceStatus();
    }

    @PUT
    public Object doPut() {
        FormData form = this.ctx.getForm();
        try {
            AdministrativeStatusManager manager = (AdministrativeStatusManager)Framework.getLocalService(AdministrativeStatusManager.class);
            manager.setNuxeoInstanceStatus(form.getString("status"), "assigned from rest interface", this.ctx.getPrincipal().getName());
            return this.redirect(this.getPath());
        }
        catch (Exception e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    @GET
    public Object doGet() {
        return this.getView("index").arg("serverInstanceId", (Object)this.administrativeStatus.getInstanceIdentifier()).arg("administrativeStatus", (Object)this.administrativeStatus.getState());
    }

    @GET
    @Path(value="/@activate")
    public Object doActivate() {
        try {
            AdministrativeStatusManager manager = (AdministrativeStatusManager)Framework.getLocalService(AdministrativeStatusManager.class);
            manager.setNuxeoInstanceStatus("active", "", this.ctx.getPrincipal().getName());
            return this.redirect(this.getPath());
        }
        catch (Exception e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    @GET
    @Path(value="/@passivate")
    public Object passivate() {
        try {
            AdministrativeStatusManager manager = (AdministrativeStatusManager)Framework.getLocalService(AdministrativeStatusManager.class);
            manager.setNuxeoInstanceStatus("passive", "", this.ctx.getPrincipal().getName());
            return this.redirect(this.getPath());
        }
        catch (Exception e) {
            throw WebException.wrap((Throwable)e);
        }
    }
}

