/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.server.resteasy;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Path;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.jboss.resteasy.core.Dispatcher;
import org.jboss.resteasy.core.ResourceMethodRegistry;
import org.jboss.resteasy.core.registry.RootSegment;
import org.jboss.resteasy.plugins.server.resourcefactory.POJOResourceFactory;
import org.jboss.resteasy.plugins.server.resourcefactory.SingletonResource;
import org.jboss.resteasy.spi.ResourceFactory;
import org.nuxeo.ecm.webengine.ResourceBinding;
import org.nuxeo.ecm.webengine.ResourceRegistry;
import org.nuxeo.ecm.webengine.WebException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceRegistryImpl
implements ResourceRegistry {
    protected final Dispatcher dispatcher;
    protected final ResourceMethodRegistry registry;
    protected List<ResourceBinding> bindings;

    public ResourceRegistryImpl(Dispatcher dispatcher) {
        this.registry = (ResourceMethodRegistry)dispatcher.getRegistry();
        this.bindings = new ArrayList<ResourceBinding>();
        this.dispatcher = dispatcher;
    }

    public synchronized void addBinding(ResourceBinding binding) {
        this.registerBinding(binding);
        this.bindings.add(binding);
    }

    public void registerBinding(ResourceBinding binding) {
        if (binding.clazz == null) {
            throw new WebException("Invalid resource binding: " + binding.path + " -> " + binding.clazz + ". No resource class specified.");
        }
        if (binding.singleton) {
            Object obj = null;
            try {
                obj = binding.clazz.newInstance();
            }
            catch (Exception e) {
                throw WebException.wrap((Throwable)e);
            }
            if (binding.clazz.getAnnotation(Path.class) != null) {
                this.registry.addSingletonResource(obj);
            } else {
                this.registry.addResourceFactory((ResourceFactory)new SingletonResource(obj), binding.path, binding.clazz);
            }
        } else if (binding.clazz.getAnnotation(Path.class) != null) {
            this.registry.addPerRequestResource(binding.clazz);
        } else {
            this.registry.addResourceFactory((ResourceFactory)new POJOResourceFactory(binding.clazz), binding.path, binding.clazz);
        }
    }

    public synchronized void removeBinding(ResourceBinding binding) {
        this.unregisterBinding(binding);
        this.bindings.remove(binding);
    }

    public void unregisterBinding(ResourceBinding binding) {
        try {
            if (binding.clazz.getAnnotation(Path.class) == null) {
                this.removeRegistration(binding.path, binding.clazz);
            } else {
                this.registry.removeRegistrations(binding.clazz);
            }
        }
        catch (Exception e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    public synchronized ResourceBinding[] getBindings() {
        return this.bindings.toArray(new ResourceBinding[this.bindings.size()]);
    }

    public synchronized void reload() {
        this.clearRegistrations();
        for (ResourceBinding binding : this.bindings) {
            this.registerBinding(binding);
        }
    }

    public synchronized void clear() {
        this.clearRegistrations();
        this.bindings = new ArrayList<ResourceBinding>();
    }

    public void clearRegistrations() {
        try {
            Field f = this.registry.getClass().getDeclaredField("rootSegment");
            if (!f.isAccessible()) {
                f.setAccessible(true);
            }
            RootSegment rootSegment = new RootSegment();
            f.set(this.registry, rootSegment);
        }
        catch (Exception e) {
            throw WebException.wrap((String)"Failed to reload resources", (Throwable)e);
        }
    }

    protected void removeRegistration(String base, Class<?> clazz) throws Exception {
        Method m = this.registry.getClass().getDeclaredMethod("removeRegistration", String.class, Class.class);
        m.setAccessible(true);
        m.invoke((Object)this.registry, base, clazz);
    }

    public void addMessageBodyReader(MessageBodyReader<?> reader) {
        this.dispatcher.getProviderFactory().addMessageBodyReader(reader);
    }

    public void addMessageBodyWriter(MessageBodyWriter<?> writer) {
        this.dispatcher.getProviderFactory().addMessageBodyWriter(writer);
    }
}

