/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.server.resteasy;

import java.io.IOException;
import javax.servlet.GenericServlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.resteasy.core.Dispatcher;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.core.ThreadLocalResteasyProviderFactory;
import org.jboss.resteasy.plugins.providers.ByteArrayProvider;
import org.jboss.resteasy.plugins.providers.DefaultTextPlain;
import org.jboss.resteasy.plugins.providers.FormUrlEncodedProvider;
import org.jboss.resteasy.plugins.providers.InputStreamProvider;
import org.jboss.resteasy.plugins.providers.StreamingOutputProvider;
import org.jboss.resteasy.plugins.providers.StringTextStar;
import org.jboss.resteasy.plugins.server.servlet.HttpServletInputMessage;
import org.jboss.resteasy.plugins.server.servlet.HttpServletResponseWrapper;
import org.jboss.resteasy.plugins.server.servlet.ServletSecurityContext;
import org.jboss.resteasy.plugins.server.servlet.ServletUtil;
import org.jboss.resteasy.specimpl.UriInfoImpl;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.DefaultNuxeoExceptionHandler;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.ExceptionHelper;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.ecm.webengine.server.resteasy.ResourceContainer;
import org.nuxeo.ecm.webengine.server.resteasy.WebEngineContext;
import org.nuxeo.ecm.webengine.server.resteasy.WebEngineDispatcher;
import org.nuxeo.ecm.webengine.session.UserSession;
import org.nuxeo.runtime.api.Framework;

public class WebEngineServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(WebEngineServlet.class);
    private static final long serialVersionUID = 1L;
    private static boolean isTaglibLoaded = false;
    protected boolean enableJsp = false;
    protected WebEngineDispatcher dispatcher;

    protected void initializeBuiltinProviders(ResteasyProviderFactory providerFactory) {
        try {
            providerFactory.addMessageBodyReader((MessageBodyReader)new DefaultTextPlain());
            providerFactory.addMessageBodyWriter((MessageBodyWriter)new DefaultTextPlain());
            providerFactory.addMessageBodyReader((MessageBodyReader)new StringTextStar());
            providerFactory.addMessageBodyWriter((MessageBodyWriter)new StringTextStar());
            providerFactory.addMessageBodyReader((MessageBodyReader)new InputStreamProvider());
            providerFactory.addMessageBodyWriter((MessageBodyWriter)new InputStreamProvider());
            providerFactory.addMessageBodyReader((MessageBodyReader)new ByteArrayProvider());
            providerFactory.addMessageBodyWriter((MessageBodyWriter)new ByteArrayProvider());
            providerFactory.addMessageBodyReader((MessageBodyReader)new FormUrlEncodedProvider());
            providerFactory.addMessageBodyWriter((MessageBodyWriter)new FormUrlEncodedProvider());
            providerFactory.addMessageBodyWriter((MessageBodyWriter)new StreamingOutputProvider());
        }
        catch (Throwable t) {
            log.error((Object)t);
        }
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        ResourceContainer rc = (ResourceContainer)((Object)Framework.getRuntime().getComponent(ResourceContainer.NAME));
        this.dispatcher = rc.getDispatcher();
        this.initializeBuiltinProviders(this.dispatcher.getProviderFactory());
        String v = Framework.getProperty((String)"org.nuxeo.ecm.webengine.enableJsp");
        if ("true".equals(v)) {
            this.enableJsp = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (null == httpServletRequest.getCharacterEncoding()) {
            httpServletRequest.setCharacterEncoding("UTF-8");
        }
        if (this.enableJsp) {
            WebEngine engine = (WebEngine)Framework.getLocalService(WebEngine.class);
            if (!isTaglibLoaded) {
                WebEngineServlet webEngineServlet = this;
                synchronized (webEngineServlet) {
                    if (!isTaglibLoaded) {
                        engine.loadJspTaglib((GenericServlet)this);
                        isTaglibLoaded = true;
                    }
                }
            }
            engine.initJspRequestSupport((GenericServlet)this, httpServletRequest, httpServletResponse);
        }
        this.service(httpServletRequest.getMethod(), httpServletRequest, httpServletResponse);
        if (null != httpServletRequest.getAttribute("org.nuxeo.webengine.DisableAutoHeaders")) {
            httpServletResponse.addHeader("Pragma", "no-cache");
            httpServletResponse.addHeader("Cache-Control", "no-cache");
            httpServletResponse.addHeader("Cache-Control", "no-store");
            httpServletResponse.addHeader("Cache-Control", "must-revalidate");
            httpServletResponse.addHeader("Expires", "0");
            httpServletResponse.setDateHeader("Expires", 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(String httpMethod, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ResteasyProviderFactory defaultInstance;
        WebEngineContext ctx = null;
        try {
            defaultInstance = ResteasyProviderFactory.getInstance();
            if (defaultInstance instanceof ThreadLocalResteasyProviderFactory) {
                ThreadLocalResteasyProviderFactory.push((ResteasyProviderFactory)this.dispatcher.getProviderFactory());
            }
            HttpHeaders headers = ServletUtil.extractHttpHeaders((HttpServletRequest)request);
            UriInfoImpl uriInfo = ServletUtil.extractUriInfo((HttpServletRequest)request, (String)request.getServletPath());
            HttpResponse theResponse = this.createServletResponse(response);
            HttpRequest in = this.createHttpRequest(httpMethod, request, headers, (UriInfo)uriInfo, theResponse);
            ctx = new WebEngineContext(in, request);
            WebEngine.setActiveContext((WebContext)ctx);
            try {
                ResteasyProviderFactory.pushContext(HttpServletRequest.class, (Object)request);
                ResteasyProviderFactory.pushContext(HttpServletResponse.class, (Object)response);
                ResteasyProviderFactory.pushContext(SecurityContext.class, (Object)new ServletSecurityContext(request));
                this.dispatcher.invoke(in, theResponse);
            }
            finally {
                ResteasyProviderFactory.clearContextData();
            }
        }
        catch (Throwable t) {
            Throwable unwrappedException = DefaultNuxeoExceptionHandler.unwrapException((Throwable)t);
            if (ExceptionHelper.isClientAbortError((Throwable)unwrappedException).booleanValue()) {
                log.warn((Object)("Client disconnected: " + unwrappedException.getMessage()));
            } else if (response.isCommitted()) {
                log.error((Object)"Cannot display error page: response is already commited", t);
            } else {
                log.error((Object)"Failed to render resource", t);
                WebException exception = WebException.wrap((String)"Failed to render resource", (Throwable)t);
                response.sendError(500, exception.getStackTraceString());
            }
        }
        finally {
            UserSession us;
            defaultInstance = ResteasyProviderFactory.getInstance();
            if (defaultInstance instanceof ThreadLocalResteasyProviderFactory) {
                ThreadLocalResteasyProviderFactory.pop();
            }
            if (ctx != null && (us = ctx.getUserSession()) != null) {
                us.terminateRequest(request);
            }
            ResteasyProviderFactory.clearContextData();
            WebEngine.setActiveContext(null);
        }
    }

    protected HttpRequest createHttpRequest(String httpMethod, HttpServletRequest request, HttpHeaders headers, UriInfo uriInfo, HttpResponse theResponse) {
        return new HttpServletInputMessage(request, theResponse, headers, uriInfo, httpMethod.toUpperCase(), (SynchronousDispatcher)this.dispatcher);
    }

    protected HttpResponse createServletResponse(HttpServletResponse response) {
        return new HttpServletResponseWrapper(response, this.dispatcher.getProviderFactory());
    }
}

