/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.samples;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.webengine.model.Access;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.exceptions.WebSecurityException;
import org.nuxeo.ecm.webengine.model.impl.ModuleRoot;

@WebObject(type="Root", administrator=Access.GRANT)
@Path(value="samples")
@Produces(value={"text/html;charset=UTF-8"})
public class SamplesRoot
extends ModuleRoot {
    @GET
    public Object doGet() {
        return this.getTemplate("index.ftl");
    }

    @Path(value="hello")
    public Object doGetHello() {
        return this.newObject("Hello", new Object[0]);
    }

    @Path(value="templating")
    public Object doGetTemplating() {
        return this.newObject("Templating", new Object[0]);
    }

    @Path(value="basics")
    public Object doGetObjects() {
        return this.newObject("Basics", new Object[0]);
    }

    @Path(value="documents")
    public Object doGetBrowser() {
        return this.newObject("Documents", new Object[0]);
    }

    public Object handleError(WebApplicationException e) {
        if (e instanceof WebSecurityException) {
            return Response.status((int)401).entity((Object)this.getTemplate("error/error_401.ftl")).build();
        }
        if (e instanceof WebResourceNotFoundException) {
            return Response.status((int)404).entity((Object)this.getTemplate("error/error_404.ftl")).build();
        }
        return super.handleError(e);
    }
}

