/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.webengine.sites.fragments;

import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.theme.fragments.AbstractFragment;
import org.nuxeo.theme.models.Model;
import org.nuxeo.theme.models.ModelException;
import org.nuxeo.webengine.sites.models.ContextualLinkListModel;
import org.nuxeo.webengine.sites.models.ContextualLinkModel;
import org.nuxeo.webengine.sites.utils.SiteUtils;

public class ContextualLinkFragment
extends AbstractFragment {
    public Model getModel() throws ModelException {
        ContextualLinkListModel model = new ContextualLinkListModel();
        if (WebEngine.getActiveContext() != null) {
            WebContext ctx = WebEngine.getActiveContext();
            CoreSession session = ctx.getCoreSession();
            DocumentModel documentModel = (DocumentModel)ctx.getTargetObject().getAdapter(DocumentModel.class);
            if (documentModel.hasFacet("WebView") || "WebPage".equals(documentModel.getType())) {
                try {
                    for (DocumentModel document : session.getChildren(documentModel.getRef(), "ContextualLink")) {
                        if (document.getCurrentLifeCycleState().equals("deleted")) continue;
                        String title = SiteUtils.getString(document, "dc:title");
                        String description = SiteUtils.getString(document, "dc:description");
                        String link = SiteUtils.getString(document, "clink:link");
                        ContextualLinkModel linkModel = new ContextualLinkModel(title, description, link);
                        model.addItem((Model)linkModel);
                    }
                }
                catch (Exception e) {
                    throw new ModelException((Throwable)e);
                }
            }
        }
        return model;
    }
}

