/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.webengine.sites;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.URIUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.rest.DocumentObject;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.ecm.platform.ui.web.auth.NuxeoAuthenticationFilter;
import org.nuxeo.ecm.platform.ui.web.auth.service.PluggableAuthenticationService;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.Resource;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.webengine.sites.utils.SiteUtils;

@WebObject(type="AbstractSiteDocumentObject", superType="Document", facets={"AbstractSiteDocumentObject"})
@Produces(value={"text/html;charset=UTF-8"})
public abstract class AbstractSiteDocumentObject
extends DocumentObject {
    private static final Log log = LogFactory.getLog(AbstractSiteDocumentObject.class);
    public static final int NO_WELCOME_MEDIA = -1;
    public static final int IMAGE_WELCOME_MEDIA = 0;
    public static final int FLASH_WELCOME_MEDIA = 1;
    private boolean forceRedirectToLogout = false;

    @GET
    public Object doGet() {
        if (this.doc == null && !this.forceRedirectToLogout) {
            return this.getTemplate(this.getErrorTemplateName()).args(this.getErrorArguments());
        }
        if (this.doc == null && this.forceRedirectToLogout) {
            return this.handleAnonymousRedirectToLogout(this.ctx.getRequest());
        }
        try {
            if ("deleted".equals(this.doc.getCurrentLifeCycleState())) {
                return this.getTemplate(this.getDocumentDeletedErrorTemplateName()).args(this.getErrorArguments());
            }
        }
        catch (ClientException e1) {
            throw WebException.wrap((Throwable)e1);
        }
        this.setDoGetParameters();
        try {
            return this.getTemplate("template_default.ftl").args(this.getArguments());
        }
        catch (Exception e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    @GET
    @Path(value="logo")
    public Response getLogo() {
        Response resp = null;
        try {
            DocumentModel parentWebSite = this.getParentWebSite(this.ctx.getCoreSession());
            resp = SiteUtils.getLogoResponse(parentWebSite);
        }
        catch (Exception e) {
            if (this.doc == null) {
                log.error((Object)"Problems retrieving the logo", (Throwable)e);
            }
            log.error((Object)("Problems retrieving the logo for" + this.doc.getName()), (Throwable)e);
        }
        if (resp == null) {
            resp = this.redirect(this.getContext().getModule().getSkinPathPrefix() + "/images/logo.gif");
        }
        return resp;
    }

    @GET
    @Path(value="welcomeMedia")
    public Response getWelcomeMedia() {
        Response resp = null;
        try {
            DocumentModel parentWebSite = this.getParentWebSite(this.ctx.getCoreSession());
            Blob blob = SiteUtils.getBlob(parentWebSite, "webc:welcomeMedia");
            if (blob != null) {
                resp = Response.ok().entity((Object)blob).type(blob.getMimeType()).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while trying to display the website. ", (Throwable)e);
        }
        if (resp == null) {
            resp = this.redirect(this.getContext().getModule().getSkinPathPrefix() + "/images/logo.gif");
        }
        return resp;
    }

    public int getWelcomeMediaWidth() {
        return 200;
    }

    public int getWelcomeMediaHeight() {
        return 100;
    }

    public int getWelcomeMediaIsImage() throws Exception {
        DocumentModel parentWebSite = this.getParentWebSite(this.ctx.getCoreSession());
        Blob blob = SiteUtils.getBlob(parentWebSite, "webc:welcomeMedia");
        if (blob == null || blob.getMimeType() == null) {
            return -1;
        }
        if (blob.getMimeType().startsWith("image/")) {
            return 0;
        }
        return 1;
    }

    @GET
    @Path(value="search")
    public Object getSearchParameters() {
        this.setSearchParameters();
        try {
            return this.getTemplate("template_default.ftl").args(this.getArguments());
        }
        catch (Exception e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    @POST
    @Path(value="search")
    public Object _getSearchParameters() {
        return this.getSearchParameters();
    }

    @Path(value="{path}")
    public Resource traverse(@PathParam(value="path") String path) {
        try {
            return this.newDocument(path);
        }
        catch (Exception e) {
            if (e instanceof WebResourceNotFoundException) {
                CoreSession session = this.ctx.getCoreSession();
                try {
                    if (session.hasPermission(this.doc.getRef(), "AddChildren")) {
                        DocumentObject parent = (DocumentObject)this.ctx.getTargetObject();
                        this.ctx.getRequest().setAttribute("org.nuxeo.theme.perspective", (Object)"create");
                        this.ctx.getRequest().setAttribute("pageName", (Object)path);
                        return parent;
                    }
                    return this.newObject(this.getWebPageDocumentType(), new Object[]{path});
                }
                catch (ClientException ce) {
                    throw WebException.wrap((Throwable)ce);
                }
            }
            throw WebException.wrap((Throwable)e);
        }
    }

    @POST
    @Path(value="createWebPage")
    public Object createWebPage() {
        try {
            CoreSession session = this.ctx.getCoreSession();
            DocumentModel createdDocument = SiteUtils.createDocument(this.ctx.getRequest(), session, this.doc.getPathAsString(), this.getWebPageDocumentType());
            DocumentModel parentWebSite = this.getParentWebSite(session);
            String path = SiteUtils.getPagePath(parentWebSite, createdDocument);
            return this.redirect(path.toString());
        }
        catch (Exception e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    @GET
    @Path(value="homePagePath")
    public Object getHomePagePath() {
        try {
            DocumentModel parentWebSite = this.getParentWebSite(this.ctx.getCoreSession());
            StringBuilder path = new StringBuilder(SiteUtils.getWebContainersPath()).append("/");
            path.append(SiteUtils.getString(parentWebSite, "webc:url"));
            return this.redirect(path.toString());
        }
        catch (Exception e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    @GET
    @Path(value="delete")
    public Response remove() {
        return this.doDelete();
    }

    @DELETE
    public Response doDelete() {
        CoreSession session = this.ctx.getCoreSession();
        try {
            DocumentModel webContainer = SiteUtils.getFirstWebSiteParent(session, this.doc);
            DocumentRef docRef = this.doc.getRef();
            if (session.getAllowedStateTransitions(docRef).contains("delete")) {
                session.followTransition(docRef, "delete");
            } else {
                session.removeDocument(docRef);
            }
            session.save();
            return this.redirect(SiteUtils.getPagePath(webContainer, webContainer));
        }
        catch (Exception e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    protected String getWebSiteDocumentType() {
        return "WebSite";
    }

    protected String getWebPageDocumentType() {
        return "WebPage";
    }

    protected void setSearchParameters() {
        this.ctx.getRequest().setAttribute("org.nuxeo.theme.theme", (Object)this.getSearchThemePage());
        this.ctx.setProperty("searchParam", (Object)this.ctx.getRequest().getParameter("searchParam"));
        this.ctx.setProperty("searchParamDocType", (Object)this.getWebPageDocumentType());
    }

    protected Map<String, Object> getArguments() throws Exception {
        HashMap<String, Object> root = new HashMap<String, Object>();
        DocumentModel parentWebSite = this.getParentWebSite(this.getCoreSession());
        root.put("name", SiteUtils.getString(parentWebSite, "webc:name", ""));
        root.put("siteDescription", SiteUtils.getString(parentWebSite, "webcontainer:baseline", ""));
        root.put("siteCreatorEmail", "mailto:" + SiteUtils.getString(parentWebSite, "webc:email", ""));
        MimetypeRegistry mimetypeService = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
        root.put("mimetypeService", mimetypeService);
        return root;
    }

    protected void setDoGetParameters() {
        String theme = SiteUtils.getString(this.doc, this.getSchemaFieldThemeName(), this.getDefaultSchemaFieldThemeValue());
        String themePage = SiteUtils.getString(this.doc, this.getSchemaFieldThemePageName(), this.getDefaultSchemaFieldThemePageValue());
        this.ctx.getRequest().setAttribute("org.nuxeo.theme.theme", (Object)(theme + "/" + themePage));
        String currentPerspective = (String)this.ctx.getRequest().getAttribute("org.nuxeo.theme.perspective");
        if (StringUtils.isEmpty((String)currentPerspective)) {
            this.ctx.getRequest().setAttribute("org.nuxeo.theme.perspective", (Object)"view");
        }
    }

    protected DocumentModel getParentWebSite(CoreSession session) throws Exception {
        DocumentModel parentWebSite = null;
        parentWebSite = !this.doc.hasFacet("WebView") ? SiteUtils.getFirstWebSiteParent(session, this.doc) : this.doc;
        return parentWebSite;
    }

    protected abstract String getSearchThemePage();

    protected abstract String getSchemaFieldThemeName();

    protected abstract String getSchemaFieldThemePageName();

    protected abstract String getDefaultSchemaFieldThemeValue();

    protected abstract String getDefaultSchemaFieldThemePageValue();

    protected abstract String getErrorTemplateName();

    protected abstract String getDocumentDeletedErrorTemplateName();

    protected abstract Map<String, Object> getErrorArguments();

    protected Response handleAnonymousRedirectToLogout(HttpServletRequest request) {
        HashMap<String, String> urlParameters = new HashMap<String, String>();
        urlParameters.put("securityError", "true");
        urlParameters.put("forceAnonymousLogin", "true");
        if (request.getAttribute("requestedUrl") != null) {
            urlParameters.put("requestedUrl", (String)request.getAttribute("requestedUrl"));
        } else {
            urlParameters.put("requestedUrl", NuxeoAuthenticationFilter.getRequestedUrl((HttpServletRequest)request));
        }
        String baseURL = "";
        try {
            baseURL = this.initAuthenticationService().getBaseURL((ServletRequest)request) + "logout";
        }
        catch (ClientException e) {
            throw WebException.wrap((Throwable)e);
        }
        request.setAttribute("nuxeo.disable.redirect.wrapper", (Object)true);
        baseURL = URIUtils.addParametersToURIQuery((String)baseURL, urlParameters);
        this.setForceRedirectToLogout(false);
        return this.redirect(baseURL);
    }

    protected void setForceRedirectToLogout(boolean redirectToLogout) {
        this.forceRedirectToLogout = redirectToLogout;
    }

    protected PluggableAuthenticationService initAuthenticationService() throws ClientException {
        PluggableAuthenticationService service = (PluggableAuthenticationService)Framework.getRuntime().getComponent("org.nuxeo.ecm.platform.ui.web.auth.service.PluggableAuthenticationService");
        if (service == null) {
            log.error((Object)"Unable to get Service org.nuxeo.ecm.platform.ui.web.auth.service.PluggableAuthenticationService");
            throw new ClientException("Can't initialize Nuxeo Pluggable Authentication Service");
        }
        return service;
    }
}

