/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.webengine.sites.fragments;

import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.theme.fragments.AbstractFragment;
import org.nuxeo.theme.models.Model;
import org.nuxeo.theme.models.ModelException;
import org.nuxeo.webengine.sites.models.WebpageListModel;
import org.nuxeo.webengine.sites.models.WebpageModel;
import org.nuxeo.webengine.sites.utils.SiteQueriesCollection;
import org.nuxeo.webengine.sites.utils.SiteUtils;

public class MinisiteLastPublishedFragment
extends AbstractFragment {
    private int noPages = 5;
    private int noWordsFromContent = 50;

    public Model getModel() throws ModelException {
        WebpageListModel model = new WebpageListModel();
        if (WebEngine.getActiveContext() != null) {
            WebContext ctx = WebEngine.getActiveContext();
            CoreSession session = ctx.getCoreSession();
            DocumentModel documentModel = (DocumentModel)ctx.getTargetObject().getAdapter(DocumentModel.class);
            try {
                DocumentModel ws = SiteUtils.getFirstWebSiteParent(session, documentModel);
                DocumentModelList webPages = SiteQueriesCollection.queryLastModifiedPages(session, ws.getPathAsString(), "WebPage", this.noPages);
                for (DocumentModel webPage : webPages) {
                    if (webPage.getCurrentLifeCycleState().equals("deleted")) continue;
                    String name = SiteUtils.getString(webPage, "dc:title");
                    String path = SiteUtils.getPagePath(ws, webPage);
                    String description = SiteUtils.getString(webPage, "dc:description");
                    String content = SiteUtils.getFistNWordsFromString(SiteUtils.getString(webPage, "webp:content"), this.noWordsFromContent);
                    String author = SiteUtils.getString(webPage, "dc:creator");
                    GregorianCalendar modificationDate = SiteUtils.getGregorianCalendar(webPage, "dc:modified");
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd MMMM", WebEngine.getActiveContext().getLocale());
                    String formattedString = simpleDateFormat.format(modificationDate.getTime());
                    String[] splitFormattedString = formattedString.split(" ");
                    String numberComments = Integer.toString(SiteUtils.getNumberCommentsForPage(session, webPage));
                    WebpageModel webpageModel = new WebpageModel(name, path, description, content, author, splitFormattedString[0], splitFormattedString[1], numberComments);
                    model.addItem((Model)webpageModel);
                }
            }
            catch (Exception e) {
                throw new ModelException((Throwable)e);
            }
        }
        return model;
    }
}

