/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.webengine.sites.webcomments;

import java.util.ArrayList;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.rest.CommentService;
import org.nuxeo.ecm.webengine.model.WebAdapter;
import org.nuxeo.webengine.sites.utils.SiteUtils;

@WebAdapter(name="webcomments", type="WebCommentService", targetType="Document", targetFacets={"Commentable"})
public class WebCommentService
extends CommentService {
    protected DocumentModel createCommentDocument(CoreSession session, DocumentModel target, DocumentModel comment) throws Exception {
        DocumentModel site = SiteUtils.getFirstWebSiteParent(session, target);
        if (site == null) {
            return super.createCommentDocument(session, target, comment);
        }
        return WebCommentService.getCommentManager().createLocatedComment(target, comment, site.getPathAsString());
    }

    protected void publishComment(CoreSession session, DocumentModel target, DocumentModel comment) throws Exception {
        if (SiteUtils.isCurrentModerated(session, target) && !SiteUtils.isModeratedByCurrentUser(session, target)) {
            ArrayList<String> moderators = SiteUtils.getModerators(session, target);
            WebCommentService.getCommentsModerationService().startModeration(session, target, comment.getId(), moderators);
        } else {
            super.publishComment(session, target, comment);
        }
        session.save();
    }
}

