/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.webengine.sites;

import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.rest.DocumentObject;
import org.nuxeo.ecm.platform.tag.TagService;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.WebAdapter;
import org.nuxeo.ecm.webengine.model.impl.DefaultAdapter;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.webengine.sites.AbstractSiteDocumentObject;
import org.nuxeo.webengine.sites.utils.SiteUtils;

@WebAdapter(name="tag", type="TagAdapter", targetType="Document")
@Produces(value={"text/html;charset=UTF-8"})
public class TagAdapter
extends DefaultAdapter {
    @GET
    @Path(value="{id}")
    public Object changePerspective(@PathParam(value="id") String tagId) {
        try {
            DocumentObject documentObject = (DocumentObject)this.getTarget();
            this.ctx.setProperty("tag_document", (Object)tagId);
            if (documentObject instanceof AbstractSiteDocumentObject) {
                AbstractSiteDocumentObject abstractSiteDocumentObject = (AbstractSiteDocumentObject)documentObject;
                this.ctx.getRequest().setAttribute("org.nuxeo.theme.theme", (Object)abstractSiteDocumentObject.getSearchThemePage());
                return this.getTemplate("template_default.ftl").args(abstractSiteDocumentObject.getArguments());
            }
            return this.getTemplate("template_default.ftl");
        }
        catch (Exception e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    @POST
    @Path(value="addTagging")
    public Object addTagging() {
        try {
            DocumentObject documentObject = (DocumentObject)this.getTarget();
            DocumentModel doc = documentObject.getDocument();
            CoreSession session = this.ctx.getCoreSession();
            String tagLabel = this.ctx.getRequest().getParameter("tagLabel");
            TagService tagService = (TagService)Framework.getService(TagService.class);
            if (tagService != null) {
                String[] tagLabelArray;
                for (String label : tagLabelArray = tagLabel.split(",")) {
                    if ((label = label.trim()).length() <= 0) continue;
                    tagService.tag(session, doc.getId(), label, null);
                }
            }
            String path = SiteUtils.getPagePath(SiteUtils.getFirstWebSiteParent(session, doc), doc);
            return this.redirect(path);
        }
        catch (Exception e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    @GET
    @Path(value="removeTagging")
    public Object removeTagging() {
        try {
            DocumentObject documentObject = (DocumentObject)this.getTarget();
            DocumentModel doc = documentObject.getDocument();
            CoreSession session = this.ctx.getCoreSession();
            String label = this.ctx.getRequest().getParameter("taggingId");
            TagService tagService = (TagService)Framework.getService(TagService.class);
            if (tagService != null) {
                tagService.untag(session, doc.getId(), label, null);
            }
            String path = SiteUtils.getPagePath(SiteUtils.getFirstWebSiteParent(session, doc), doc);
            return this.redirect(path);
        }
        catch (Exception e) {
            throw WebException.wrap((Throwable)e);
        }
    }
}

