/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.seqgen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.VersionType;
import org.nuxeo.ecm.core.api.ConcurrentUpdateException;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.uidgen.AbstractUIDSequencer;
import org.nuxeo.elasticsearch.api.ESClient;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.runtime.api.Framework;

public class ESUIDSequencer
extends AbstractUIDSequencer {
    protected static final int MAX_RETRY = 3;
    protected ESClient esClient = null;
    protected String indexName;

    public void init() {
        if (this.esClient != null) {
            return;
        }
        ElasticSearchAdmin esa = (ElasticSearchAdmin)Framework.getService(ElasticSearchAdmin.class);
        this.esClient = esa.getClient();
        this.indexName = esa.getIndexNameForType("seqId");
        try {
            boolean indexExists = this.esClient.indexExists(this.indexName);
            if (!indexExists) {
                throw new NuxeoException(String.format("Sequencer %s needs an elasticSearchIndex contribution with type %s", this.getName(), "seqId"));
            }
        }
        catch (NoSuchElementException | NuxeoException e) {
            this.dispose();
            throw e;
        }
    }

    public void dispose() {
        if (this.esClient == null) {
            return;
        }
        this.esClient = null;
        this.indexName = null;
    }

    public void initSequence(String key, long id) {
        String source = "{ \"ts\" : " + System.currentTimeMillis() + "}";
        IndexResponse res = this.esClient.index(new IndexRequest(this.indexName, "seqId", key).versionType(VersionType.EXTERNAL).version(id).source(source, XContentType.JSON));
    }

    public long getNextLong(String sequenceName) {
        String source = "{ \"ts\" : " + System.currentTimeMillis() + "}";
        IndexResponse res = this.esClient.index(new IndexRequest(this.indexName, "seqId", sequenceName).source(source, XContentType.JSON));
        return res.getVersion();
    }

    public List<Long> getNextBlock(String key, int blockSize) {
        if (blockSize == 1) {
            return Collections.singletonList(this.getNextLong(key));
        }
        ArrayList<Long> ret = new ArrayList<Long>(blockSize);
        long first = this.getNextBlockWithRetry(key, blockSize);
        for (long i = 0L; i < (long)blockSize; ++i) {
            ret.add(first + i);
        }
        return ret;
    }

    protected long getNextBlockWithRetry(String key, int blockSize) {
        for (int i = 0; i < 3; ++i) {
            long ret = this.getNextLong(key);
            try {
                this.initSequence(key, ret + (long)blockSize - 1L);
                return ret;
            }
            catch (ConcurrentUpdateException e) {
                if (i != 2) continue;
                throw e;
            }
        }
        throw new NuxeoException("Unable to get a block of sequence");
    }
}

