/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.snapshot.listeners;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.snapshot.Snapshotable;

public class SnapshotableListener
implements EventListener {
    private static final Log log = LogFactory.getLog(SnapshotableListener.class);
    public static final String SNAPSHOT_VERSIONING_OPTION_KEY = "snapshotVersioningOption";

    public void handleEvent(Event event) throws ClientException {
        VersioningOption option;
        String eventName = event.getName();
        if (!"documentModified".equals(eventName)) {
            return;
        }
        if (!(event.getContext() instanceof DocumentEventContext)) {
            return;
        }
        DocumentEventContext ctx = (DocumentEventContext)event.getContext();
        DocumentModel doc = ctx.getSourceDocument();
        if (doc.isProxy() || doc.isVersion() || !doc.hasFacet("Snapshotable")) {
            return;
        }
        String versioningOption = (String)((Object)ctx.getProperty(SNAPSHOT_VERSIONING_OPTION_KEY));
        if (versioningOption == null) {
            return;
        }
        try {
            option = VersioningOption.valueOf((String)versioningOption);
        }
        catch (Exception e) {
            log.error((Object)String.format("Unknown versioning option value '%s': %s", versioningOption, e.getMessage()));
            log.debug((Object)e, (Throwable)e);
            return;
        }
        if (option == VersioningOption.NONE) {
            return;
        }
        try {
            Snapshotable snapshotable = (Snapshotable)doc.getAdapter(Snapshotable.class);
            snapshotable.createSnapshot(option);
        }
        catch (ClientException e) {
            event.markRollBack(e.getMessage(), (Throwable)e);
            throw e;
        }
    }
}

