/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.jsf2.migration;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.io.FilenameUtils;
import org.nuxeo.ecm.jsf2.migration.impl.MigrationServiceImpl;

public class MigrationToJSF2 {
    public static void main(String[] args) throws Exception {
        PosixParser parser = new PosixParser();
        Options options = new Options();
        options.addOption(Flags.MIGRATE);
        options.addOption(Flags.FORMAT);
        options.addOption(Flags.RECURSIVE);
        CommandLine cmd = null;
        try {
            cmd = parser.parse(options, args);
            if (cmd.getArgs().length != 1) {
                throw new ParseException("Must specify project directory.");
            }
        }
        catch (ParseException e) {
            HelpFormatter formatter = new HelpFormatter();
            System.out.println(e.getMessage());
            formatter.printHelp("java -jar nuxeo-jsf2-migration-<version>.jar <path to project>", options);
            System.exit(-1);
        }
        String path = cmd.getArgs()[0];
        final boolean migration = cmd.hasOption(Flags.MIGRATE.getOpt());
        final boolean format = cmd.hasOption(Flags.FORMAT.getOpt());
        boolean recursive = cmd.hasOption(Flags.RECURSIVE.getOpt());
        File file = new File(path);
        if (!file.exists()) {
            System.out.println("The file does not exist");
            return;
        }
        boolean isDirectory = file.isDirectory();
        if (recursive && !isDirectory) {
            System.out.println("The file is not a directory");
            return;
        }
        if (!isDirectory) {
            if (!MigrationToJSF2.isValidXHTMLFile(path)) {
                System.out.println("The specified file is not xhtml file.");
                return;
            }
            MigrationToJSF2.processSingleXHTMLFile(file, migration, format);
        } else if (!recursive) {
            if (!MigrationToJSF2.isValidProjectDirectory(path)) {
                System.out.println("The specified directory is not a valid project directory.");
                return;
            }
            MigrationToJSF2.processDirectory(file.getAbsolutePath(), migration, format);
        } else {
            Path startingDir = Paths.get(path, new String[0]);
            Files.walkFileTree(startingDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    return MigrationToJSF2.processDirectory(dir.toFile().getPath(), migration, format) ? FileVisitResult.SKIP_SUBTREE : FileVisitResult.CONTINUE;
                }
            });
        }
    }

    private static boolean processDirectory(String directory, boolean migration, boolean format) {
        if (!MigrationToJSF2.isValidProjectDirectory(directory)) {
            return false;
        }
        System.out.println(String.format("Analyzing %s", directory));
        long start = System.currentTimeMillis();
        MigrationServiceImpl migrationService = new MigrationServiceImpl();
        List<File> listXHTMLFiles = migrationService.getAllXhtmlFiles(MigrationToJSF2.getXHTMLRootDirectory(directory));
        return MigrationToJSF2.processAnalyze(directory, migration, format, start, listXHTMLFiles);
    }

    private static boolean processAnalyze(String directory, boolean migration, boolean format, long start, List<File> listXHTMLFiles) {
        File report = new File(directory + "/report.txt");
        MigrationServiceImpl migrationService = new MigrationServiceImpl();
        try {
            migrationService.analyzeProject(report, listXHTMLFiles, migration, format);
        }
        catch (IOException ex) {
            System.out.println(String.format("Error while generating the report : %s", ex.getMessage()));
        }
        long timeElapsed = System.currentTimeMillis() - start;
        System.out.println(String.format("The analyze is done in %d ms", timeElapsed));
        return true;
    }

    private static boolean processSingleXHTMLFile(File file, boolean migration, boolean format) {
        return MigrationToJSF2.processAnalyze(file.getParent(), migration, format, System.currentTimeMillis(), Arrays.asList(file));
    }

    private static File getXHTMLRootDirectory(String directory) {
        String pathXhtmlRootDirectory = String.format("%s/src/main/resources/web/nuxeo.war/", directory);
        return new File(pathXhtmlRootDirectory);
    }

    private static boolean isValidProjectDirectory(String directory) {
        File xhtmlRootDirectory = MigrationToJSF2.getXHTMLRootDirectory(directory);
        return xhtmlRootDirectory.exists();
    }

    private static boolean isValidXHTMLFile(String path) {
        return "xhtml".equals(FilenameUtils.getExtension(path));
    }

    static class Flags {
        static final Option MIGRATE = new Option("m", "migration", false, "perform migration where possible");
        static final Option FORMAT = new Option("f", "format", false, "format original files");
        static final Option RECURSIVE = new Option("r", "recursive", false, "recursive");

        Flags() {
        }
    }
}

