/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.jsf2.migration.enumeration;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.jsf2.migration.parser.AttributeAjaxSingleParser;
import org.nuxeo.ecm.jsf2.migration.parser.AttributeValueParser;
import org.nuxeo.ecm.jsf2.migration.parser.GenericParser;
import org.nuxeo.ecm.jsf2.migration.parser.NamespaceParser;
import org.nuxeo.ecm.jsf2.migration.parser.ReRenderParser;
import org.nuxeo.ecm.jsf2.migration.parser.RuleParser;

public enum EnumTypeMigration {
    A4J_FORM_RULE("//a4j:form", "a4j.ajax.rule1.message", Severity.ERROR, GenericParser.class, false),
    A4J_RERENDER_RULE("//@reRender", "a4j.rerender.rule.message", Severity.ERROR, ReRenderParser.class, true, "render"),
    A4J_ACTIONPARAM_RULE("//a4j:actionparam", "a4j.actionParam.rule.message", Severity.ERROR, GenericParser.class, true, "a4j:param"),
    A4J_RICHTREERECURSIVE_RULE("//rich:recursiveTreeNodesAdaptor", "a4j.recursiveTreeNodesAdaptor.rule.message", Severity.ERROR, GenericParser.class, true, "rich:treeModelRecursiveAdaptor"),
    ATTRIBUTE_RICHTREENODEVAR_RULE("//rich:treeModelRecursiveAdaptor[@var]", "a4j.treeNodeVar.rule.message", Severity.ERROR, GenericParser.class, false),
    A4J_AJAXLISTENER_RULE("//a4j:ajaxListener", "a4j.ajaxlistener.rule.message", Severity.ERROR, GenericParser.class, false),
    ATTRIBUTE_AJAXSINGLE_RULE("//*[@ajaxSingle='true']", "attribute.ajaxsingle.rule.message", Severity.ERROR, AttributeAjaxSingleParser.class, true, "execute=\"@this\""),
    A4J_SUPPORT_RULE("//a4j:support", "a4j.support.rule.message", Severity.ERROR, GenericParser.class, false),
    ATTRIBUTE_EVENT_CLICK_RULE("//*[@event='onclick']", "attribute.eventclick.rule.message", Severity.ERROR, AttributeValueParser.class, true, "click"),
    RICH_SUGGESTIONBOX_RULE("//rich:suggestionbox", "rich.suggestionBox.rule.message", Severity.ERROR, GenericParser.class, false),
    RICH_MODAL_PANEL_RULE("//rich:modalPanel", "rich.modalPanel.rule.message", Severity.ERROR, GenericParser.class, true, "rich:popupPanel"),
    ERROR_READING_DOCUMENT(null, "error.reading.document.message", Severity.ERROR, null, false),
    NAMESPACE_RULE_1(null, "namespace.rule1.message", Severity.ERROR, NamespaceParser.class, true),
    NAMESPACE_RULE_2(null, "namespace.rule2.message", Severity.WARNING, null, false),
    VALUE_SELECTACTIONS_RULE("//*[@value='#{selectionActions.onClick}']", "value.selectactions.message", Severity.WARNING, GenericParser.class, false),
    TARGET_SELECTEDVALUE_RULE("//*[@target='#{selectionActions.selectedValue}']", "target.selectedvalue.message", Severity.WARNING, GenericParser.class, false),
    H_OUTPUT_TEXT_RULE("//h:outputText[@rendered and not(@value) and count(*) > 0]", "h.output.text.message", Severity.WARNING, GenericParser.class, false),
    OVERRIDE_RULE(null, "override.rule", Severity.WARNING, null, false),
    OVERRIDE_COMPAT_RULE(null, "override.compat.rule", Severity.ERROR, null, false);

    private static final Log log;
    private String xpath;
    private String keyMessage;
    private Severity severityMessage;
    private Class parser;
    private RuleParser instance;
    private boolean migrationAuto;
    private String newValue;

    private EnumTypeMigration(String xpath, String keyMessage, Severity severity, Class parser, boolean migrationAuto) {
        this.xpath = xpath;
        this.keyMessage = keyMessage;
        this.severityMessage = severity;
        this.parser = parser;
        this.migrationAuto = migrationAuto;
    }

    private EnumTypeMigration(String xpath, String keyMessage, Severity severity, Class parser, boolean migrationAuto, String newValue) {
        this.xpath = xpath;
        this.keyMessage = keyMessage;
        this.severityMessage = severity;
        this.parser = parser;
        this.migrationAuto = migrationAuto;
        this.newValue = newValue;
    }

    public String getXPath() {
        return this.xpath;
    }

    public String getKeyMessage() {
        return this.keyMessage;
    }

    public Severity getSeverity() {
        return this.severityMessage;
    }

    public boolean isMigrationAuto() {
        return this.migrationAuto;
    }

    public String getNewValue() {
        return this.newValue;
    }

    public RuleParser getInstance(boolean doMigration) {
        try {
            this.initParser(doMigration);
        }
        catch (Exception ex) {
            log.error(ex.getMessage());
        }
        return this.instance;
    }

    public void initParser(boolean doMigration) throws Exception {
        if (this.instance == null) {
            this.instance = (RuleParser)this.parser.newInstance();
        }
        this.instance.init(this, doMigration);
    }

    public void resetInstance() {
        this.instance = null;
    }

    public static List<EnumTypeMigration> getTypesMigration() {
        ArrayList<EnumTypeMigration> result = new ArrayList<EnumTypeMigration>();
        for (EnumTypeMigration type : EnumTypeMigration.values()) {
            if (type.parser == null) continue;
            result.add(type);
        }
        return result;
    }

    static {
        log = LogFactory.getLog(EnumTypeMigration.class);
    }

    private static enum Severity {
        INFO,
        WARNING,
        ERROR;

    }
}

