/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.jsf2.migration.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.jaxen.JaxenException;
import org.nuxeo.ecm.jsf2.migration.api.MigrationService;
import org.nuxeo.ecm.jsf2.migration.enumeration.EnumTypeMigration;
import org.nuxeo.ecm.jsf2.migration.parser.RuleParser;
import org.nuxeo.ecm.jsf2.migration.report.FileReport;

public class MigrationServiceImpl
implements MigrationService {
    private static Log logger = LogFactory.getLog(MigrationServiceImpl.class);
    private static final String FILE_EXTENSION = "xhtml";
    private static final String NOTHING_MESSAGE = "file.migration.nothing.message";
    private static final String SUFFIX_DETAILED_MESSAGE = ".detailed";
    private static final String SUFFIX_SUMMARIZED_MESSAGE = ".summarized";
    protected static Set<String> nuxeoTemplates;
    protected static Set<String> nuxeoTemplatesCompletePath;
    protected static Set<String> nuxeoCompatTemplates;
    protected static Set<String> nuxeoCompatTemplatesCompletePath;

    @Override
    public List<File> getAllXhtmlFiles(File root) {
        ArrayList<File> listFiles = new ArrayList<File>();
        for (File children : root.listFiles()) {
            String extension;
            if (children.isDirectory()) {
                listFiles.addAll(this.getAllXhtmlFiles(children));
            }
            if (!children.isFile() || !FILE_EXTENSION.equals(extension = FilenameUtils.getExtension(children.getName()))) continue;
            listFiles.add(children);
        }
        return listFiles;
    }

    @Override
    public void analyzeProject(File report, List<File> listFiles, boolean doMigration, boolean format) throws IOException {
        if (!report.exists()) {
            report.createNewFile();
        }
        PrintWriter printWriter = new PrintWriter(report);
        printWriter.append("##############################\n");
        printWriter.append("# Migration report for JSF 2 #\n");
        printWriter.append("##############################\n\n");
        ArrayList<FileReport> listReports = new ArrayList<FileReport>();
        for (File file : listFiles) {
            try {
                listReports.add(this.analyzeFile(file, true, doMigration, format));
            }
            catch (DocumentException ex) {
                System.out.println(String.format("Error while reading file %s.", file.getName()));
                System.out.println(ex.getMessage());
            }
            catch (JaxenException jex) {
                System.out.println(String.format("Error while parsing file %s.", file.getName()));
                System.out.println(jex.getMessage());
            }
        }
        this.generateReport(listReports, printWriter);
        printWriter.close();
    }

    private void generateReport(List<FileReport> listResults, PrintWriter report) throws IOException {
        Properties reportProp = new Properties();
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("report.properties");
        reportProp.load(is);
        this.generateSummaryReport(listResults, report, reportProp);
        this.generateDetailedReport(listResults, report, reportProp);
    }

    private void generateSummaryReport(List<FileReport> listResults, PrintWriter report, Properties reportProp) throws IOException {
        report.append("Summary\n");
        report.append("#######\n");
        report.append("Number of files analyzed : " + listResults.size() + "\n");
        for (EnumTypeMigration type : EnumTypeMigration.values()) {
            int occurence = 0;
            for (FileReport fileReport : listResults) {
                if (!fileReport.getListMigrations().containsKey((Object)type)) continue;
                occurence += fileReport.getListMigrations().get((Object)type).intValue();
            }
            if (occurence <= 0) continue;
            report.append(" * [" + (Object)((Object)type.getSeverity()) + "] ");
            String key = type.getKeyMessage() + SUFFIX_SUMMARIZED_MESSAGE;
            report.append(MessageFormat.format(reportProp.getProperty(key), occurence));
            report.append('\n');
        }
        report.append("\n");
    }

    private void generateDetailedReport(List<FileReport> listResults, PrintWriter report, Properties reportProp) throws IOException {
        report.append("Details\n");
        report.append("#######");
        for (FileReport result : listResults) {
            report.append('\n');
            report.append(result.getAttachedFile().getName());
            report.append("\n-----------------------\n");
            if (result.getListMigrations().size() == 0) {
                report.append(reportProp.getProperty(NOTHING_MESSAGE));
                report.append('\n');
            }
            for (EnumTypeMigration type : result.getListMigrations().keySet()) {
                List<String> listParams = result.getListParams().get((Object)type);
                String key = type.getKeyMessage() + SUFFIX_DETAILED_MESSAGE;
                if (!reportProp.containsKey(key)) {
                    key = type.getKeyMessage() + SUFFIX_SUMMARIZED_MESSAGE;
                }
                String messageReport = MessageFormat.format(reportProp.getProperty(key), listParams.toArray());
                report.append("[" + (Object)((Object)type.getSeverity()) + "] ");
                report.append(messageReport);
                report.append('\n');
            }
        }
    }

    @Override
    public FileReport analyzeFile(File file, boolean completePath, boolean doMigration, boolean format) throws JaxenException, DocumentException {
        FileReport fileReport = new FileReport(file);
        this.analyzeOverriddenFile(fileReport, file, completePath, this.getNuxeoTemplates(), this.getNuxeoTemplatesCompletePath(), EnumTypeMigration.OVERRIDE_RULE);
        this.analyzeOverriddenFile(fileReport, file, completePath, this.getNuxeoCompatTemplates(), this.getNuxeoCompatTemplatesCompletePath(), EnumTypeMigration.OVERRIDE_COMPAT_RULE);
        return this.analyzeFileForRules(file, fileReport, EnumTypeMigration.getTypesMigration(), doMigration, format);
    }

    @Override
    public FileReport analyzeFileForRules(File file, FileReport fileReport, List<EnumTypeMigration> listRules, boolean doMigration, boolean format) throws JaxenException, DocumentException {
        SAXReader reader = new SAXReader();
        try {
            reader.setFeature("http://xml.org/sax/features/validation", false);
            reader.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            Document xhtmlDoc = reader.read(file);
            Document xhtmlOriginal = (Document)xhtmlDoc.clone();
            for (EnumTypeMigration type : listRules) {
                RuleParser parser = type.getInstance(doMigration);
                if (parser != null) {
                    parser.parse(xhtmlDoc, fileReport);
                    if (doMigration) {
                        parser.migrate(xhtmlDoc);
                    }
                }
                type.resetInstance();
            }
            if (doMigration && fileReport.getListMigrations().size() > 0) {
                if (format) {
                    this.createFile(xhtmlOriginal, file.getAbsolutePath(), false);
                }
                this.createFile(xhtmlDoc, file.getAbsolutePath() + ".migrated", true);
            }
        }
        catch (DocumentException docEx) {
            ArrayList<String> params = new ArrayList<String>();
            params.add(docEx.getMessage());
            fileReport.getListParams().put(EnumTypeMigration.ERROR_READING_DOCUMENT, params);
            fileReport.getListMigrations().put(EnumTypeMigration.ERROR_READING_DOCUMENT, 1);
        }
        catch (Exception ex) {
            logger.error(String.format("Error while analyzing file '%s' : %s", file.getName(), ex.getMessage()));
        }
        return fileReport;
    }

    protected void createFile(Document input, String filePath, boolean createNewFile) throws Exception {
        File fileMigrated = new File(filePath);
        if (createNewFile) {
            fileMigrated.createNewFile();
        }
        PrintWriter printWriter = new PrintWriter(fileMigrated);
        OutputFormat format = new OutputFormat();
        format.setIndentSize(2);
        format.setNewlines(true);
        format.setTrimText(true);
        XMLWriter writer = new XMLWriter(printWriter, format);
        writer.write(input);
        printWriter.close();
    }

    @Override
    public boolean checkOverriddenTemplate(File file, Set<String> listTemplatesRef, boolean completePath) {
        StringBuilder fileName = new StringBuilder();
        if (completePath) {
            File parent;
            fileName.append("nuxeo.war/");
            ArrayList<String> listParents = new ArrayList<String>();
            if (parent != null && parent.exists()) {
                for (parent = file.getParentFile(); parent != null && !"nuxeo.war".equals(parent.getName()); parent = parent.getParentFile()) {
                    listParents.add(parent.getName());
                }
            }
            for (int i = listParents.size() - 1; i >= 0; --i) {
                fileName.append((String)listParents.get(i));
                fileName.append("/");
            }
        }
        fileName.append(file.getName());
        return listTemplatesRef.contains(fileName.toString());
    }

    public Set<String> getNuxeoTemplates() {
        this.initListTemplates();
        return nuxeoTemplates;
    }

    public Set<String> getNuxeoTemplatesCompletePath() {
        this.initListTemplates();
        return nuxeoTemplatesCompletePath;
    }

    public Set<String> getNuxeoCompatTemplates() {
        this.initListTemplates();
        return nuxeoCompatTemplates;
    }

    public Set<String> getNuxeoCompatTemplatesCompletePath() {
        this.initListTemplates();
        return nuxeoCompatTemplatesCompletePath;
    }

    protected void initListTemplates() {
        if (nuxeoTemplates == null) {
            nuxeoTemplates = new HashSet<String>();
            nuxeoTemplatesCompletePath = new HashSet<String>();
            this.initTemplates("listTemplatesNuxeoPlatform.txt", nuxeoTemplates, nuxeoTemplatesCompletePath);
        }
        if (nuxeoCompatTemplates == null) {
            nuxeoCompatTemplates = new HashSet<String>();
            nuxeoCompatTemplatesCompletePath = new HashSet<String>();
            this.initTemplates("listCompatTemplatesNuxeoPlatform.txt", nuxeoCompatTemplates, nuxeoCompatTemplatesCompletePath);
        }
    }

    protected void initTemplates(String filename, Set<String> templates, Set<String> templatesCompletePath) {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(filename);
        if (is == null) {
            logger.error(String.format("File not found at '%s'", filename));
            return;
        }
        InputStreamReader in = new InputStreamReader(is);
        BufferedReader buff = new BufferedReader(in);
        String line = null;
        try {
            while ((line = buff.readLine()) != null) {
                templatesCompletePath.add(line);
                String[] splitLine = StringUtils.split(line, '/');
                templates.add(splitLine[splitLine.length - 1]);
            }
        }
        catch (IOException e) {
            logger.error(String.format("Error while reading file '%s': %s", filename, e.getMessage()), e);
        }
    }

    protected void analyzeOverriddenFile(FileReport fileReport, File file, boolean completePath, Set<String> templates, Set<String> templatesCompletePath, EnumTypeMigration rule) {
        boolean found = false;
        found = completePath ? this.checkOverriddenTemplate(file, templatesCompletePath, completePath) : this.checkOverriddenTemplate(file, templates, completePath);
        if (found) {
            fileReport.getListMigrations().put(rule, 1);
            ArrayList<String> params = new ArrayList<String>();
            params.add(file.getName());
            fileReport.getListParams().put(rule, params);
        }
    }
}

