/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.jsf2.migration.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.dom4j.Dom4jXPath;
import org.nuxeo.ecm.jsf2.migration.enumeration.EnumPrefixes;
import org.nuxeo.ecm.jsf2.migration.enumeration.EnumTypeMigration;
import org.nuxeo.ecm.jsf2.migration.parser.RuleParser;
import org.nuxeo.ecm.jsf2.migration.report.FileReport;

public class GenericParser
implements RuleParser {
    protected final String patternPrefix = "/[a-zAZ0-9]+:[a-zAZ0-9]+";
    protected EnumTypeMigration rule;
    protected String xpath;
    protected boolean doMigration;
    protected List<Node> listElementsToMigrate;

    @Override
    public void init(EnumTypeMigration rule, boolean doMigration) {
        this.xpath = rule.getXPath();
        this.rule = rule;
        this.doMigration = doMigration;
        this.listElementsToMigrate = new ArrayList<Node>();
    }

    @Override
    public void parse(Document input, FileReport report) throws Exception {
        Dom4jXPath xpathExpr = new Dom4jXPath(this.xpath);
        List<String> prefixesInXpath = this.getPrefix(this.xpath);
        if (prefixesInXpath.size() > 0) {
            for (String prefixInXpath : prefixesInXpath) {
                EnumPrefixes enumPrefix = EnumPrefixes.getPrefix(prefixInXpath);
                if (enumPrefix != EnumPrefixes.UNKNOWN) {
                    Namespace namespace = input.getRootElement().getNamespaceForPrefix(prefixInXpath);
                    String nsURI = namespace != null ? namespace.getURI() : enumPrefix.getNamespace();
                    SimpleNamespaceContext nsContext = new SimpleNamespaceContext();
                    nsContext.addNamespace(prefixInXpath, nsURI);
                    xpathExpr.setNamespaceContext(nsContext);
                    continue;
                }
                report.getListMigrations().put(EnumTypeMigration.NAMESPACE_RULE_2, 1);
                ArrayList<String> params = new ArrayList<String>();
                params.add(prefixInXpath);
                report.getListParams().put(EnumTypeMigration.NAMESPACE_RULE_2, params);
            }
        }
        this.listElementsToMigrate = xpathExpr.selectNodes(input);
        if (this.listElementsToMigrate.size() > 0) {
            ArrayList<String> params = new ArrayList<String>();
            params.add("" + this.listElementsToMigrate.size());
            report.getListParams().put(this.rule, params);
            report.getListMigrations().put(this.rule, this.listElementsToMigrate.size());
        }
    }

    @Override
    public void migrate(Document input) throws Exception {
        if (this.rule.isMigrationAuto()) {
            for (Node node : this.listElementsToMigrate) {
                if (StringUtils.isEmpty(this.rule.getNewValue())) continue;
                Element element = (Element)node;
                String newValue = this.rule.getNewValue();
                String prefix = null;
                if (newValue.contains(":")) {
                    String[] split = newValue.split(":");
                    prefix = split[0];
                    newValue = split[1];
                }
                element.setQName(new QName(newValue, input.getRootElement().getNamespaceForPrefix(prefix)));
            }
        }
    }

    protected List<String> getPrefix(String xpath) {
        ArrayList<String> listPrefixes = new ArrayList<String>();
        if (!StringUtils.isEmpty(xpath)) {
            Pattern pattern = Pattern.compile("/[a-zAZ0-9]+:[a-zAZ0-9]+");
            Matcher matcher = pattern.matcher(xpath);
            while (matcher.find()) {
                String prefix = matcher.group();
                prefix = prefix.split(":")[0];
                prefix = prefix.substring(1);
                listPrefixes.add(prefix);
            }
        }
        return listPrefixes;
    }
}

