/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.jsf2.migration.parser;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.dom4j.Dom4jXPath;
import org.nuxeo.ecm.jsf2.migration.enumeration.EnumPrefixes;
import org.nuxeo.ecm.jsf2.migration.enumeration.EnumTypeMigration;
import org.nuxeo.ecm.jsf2.migration.parser.GenericParser;
import org.nuxeo.ecm.jsf2.migration.report.FileReport;

public class NamespaceParser
extends GenericParser {
    protected List<String> listPrefixToMigrate;

    @Override
    public void init(EnumTypeMigration rule, boolean doMigration) {
        this.rule = rule;
        this.doMigration = doMigration;
        this.listPrefixToMigrate = new ArrayList<String>();
    }

    @Override
    public void parse(Document input, FileReport report) throws Exception {
        Element rootElement = input.getRootElement();
        for (EnumPrefixes prefix : EnumPrefixes.values()) {
            Namespace ns = rootElement.getNamespaceForPrefix(prefix.getPrefix());
            if (ns == null || StringUtils.equals(prefix.getNamespace(), ns.getURI())) continue;
            this.listPrefixToMigrate.add(prefix.getPrefix());
            report.getListMigrations().put(EnumTypeMigration.NAMESPACE_RULE_1, 1);
            ArrayList<String> params = new ArrayList<String>();
            params.add(prefix.getPrefix());
            params.add(prefix.getNamespace());
            report.getListParams().put(EnumTypeMigration.NAMESPACE_RULE_1, params);
        }
    }

    @Override
    public void migrate(Document input) throws Exception {
        Element root = input.getRootElement();
        for (String prefix : this.listPrefixToMigrate) {
            Namespace newNamespace = new Namespace(prefix, EnumPrefixes.getPrefix(prefix).getNamespace());
            Namespace oldNamespace = root.getNamespaceForPrefix(prefix);
            if (oldNamespace != null) {
                root.remove(oldNamespace);
            }
            root.add(newNamespace);
            StringBuilder prefixXpath = new StringBuilder("//");
            prefixXpath.append(prefix);
            prefixXpath.append(":*");
            Dom4jXPath xpath = new Dom4jXPath(prefixXpath.toString());
            SimpleNamespaceContext nc = new SimpleNamespaceContext();
            nc.addNamespace(prefix, oldNamespace.getURI());
            xpath.setNamespaceContext(nc);
            List elementsToMigrate = xpath.selectNodes(input);
            for (Element element : elementsToMigrate) {
                QName qname = element.getQName();
                QName newQName = new QName(qname.getName(), newNamespace, qname.getQualifiedName());
                element.setQName(newQName);
            }
        }
    }
}

