/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.jsf2.migration.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.tree.DefaultAttribute;
import org.nuxeo.ecm.jsf2.migration.parser.GenericParser;

public class ReRenderParser
extends GenericParser {
    private static final String REGEX_EL = "(\\#|\\$)\\{([^}]+)\\}([^, ]*)|([^, ]+)";

    @Override
    public void migrate(Document input) throws Exception {
        if (this.rule.isMigrationAuto()) {
            for (Node node : this.listElementsToMigrate) {
                Attribute attribute = this.createNewAttribute((Attribute)node);
                Element parentElement = node.getParent();
                parentElement.remove(node);
                parentElement.add(attribute);
            }
        }
    }

    protected Attribute createNewAttribute(Attribute originalAttribute) {
        String newName = this.rule.getNewValue();
        String newValue = this.generateNewValue(originalAttribute.getValue());
        return new DefaultAttribute(newName, newValue);
    }

    protected String generateNewValue(String value) {
        String newValue = value;
        if (!this.isValueReference(value)) {
            newValue = value.replace(',', ' ');
        } else {
            Pattern pattern = Pattern.compile(REGEX_EL);
            Matcher matcher = pattern.matcher(value);
            if (matcher.groupCount() > 1) {
                StringBuilder newValueBuilder = new StringBuilder();
                while (matcher.find()) {
                    newValueBuilder.append(matcher.group());
                    newValueBuilder.append(' ');
                }
                newValue = newValueBuilder.toString();
                newValue = newValue.substring(0, newValue.length() - 1);
            }
        }
        return newValue;
    }

    protected boolean isValueReference(String value) {
        if (value == null) {
            return false;
        }
        return value.contains("#{") && value.indexOf("#{") < value.indexOf(125) || value.contains("${") && value.indexOf("${") < value.indexOf(125);
    }
}

