/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs;

import java.util.HashMap;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.publisher.api.PublicationTree;
import org.nuxeo.ecm.platform.publisher.api.PublisherService;

@Operation(id="PublishTemplateRendition", category="Document", label="Publish Template Rendition", description="Operation to publish a rendition of a document, the parameters are the target section and the template name: delivery for example. Gives back the original document for now (should give the published proxy of the document in the next version).")
public class PublishTemplateRenditionOperation {
    public static final String ID = "PublishTemplateRendition";
    @Context
    protected CoreSession session;
    @Context
    protected PublisherService service;
    @Param(name="templateName")
    protected String templateName = "default";
    @Param(name="target")
    protected DocumentModel target;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel doc) throws ClientException {
        HashMap<String, String> params = new HashMap<String, String>();
        PublicationTree tree = this.service.getPublicationTreeFor(this.target, this.session);
        params.put("renditionName", this.templateName);
        this.service.publish(doc, tree.getNodeByPath(this.target.getPathAsString()), params);
        return doc;
    }
}

