/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.we;

import java.util.HashMap;
import java.util.Iterator;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.webengine.forms.FormData;
import org.nuxeo.ecm.webengine.model.Resource;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.ModuleRoot;
import org.nuxeo.runtime.api.Framework;

@Path(value="/publication")
@Produces(value={"text/html;charset=UTF-8"})
@WebObject(type="Publication")
public class Publication
extends ModuleRoot {
    private static final Log log = LogFactory.getLog(Publication.class);
    String searchPattern;
    private String nuxeoContextPath;

    @GET
    public Object doGet() {
        return this.getView("index");
    }

    @Path(value="section/{id}")
    public Resource getsectionContent(@PathParam(value="id") String id) {
        return this.newObject("Section", new Object[]{id});
    }

    protected void initialize(Object ... arg) {
        CoreSession session = null;
        DocumentModelList rootSections = null;
        DocumentModelList higherSections = null;
        Object testme = null;
        HashMap latestPublicationsMap = new HashMap();
        session = this.ctx.getCoreSession();
        if (session != null) {
            String query = "SELECT * FROM Document WHERE ecm:currentLifeCycleState != 'deleted' and ecm:primaryType='SectionRoot'";
            try {
                rootSections = session.query(query);
                if (!rootSections.isEmpty()) {
                    Iterator rootSectionIterator = rootSections.iterator();
                    query = "SELECT * FROM Document WHERE ecm:currentLifeCycleState != 'deleted' and ecm:primaryType='Section' AND (ecm:parentId='";
                    query = query.concat(((DocumentModel)rootSectionIterator.next()).getId());
                    while (rootSectionIterator.hasNext()) {
                        query = query.concat("' OR ecm:parentId='");
                        query = query.concat(((DocumentModel)rootSectionIterator.next()).getId());
                    }
                    query = query.concat("')");
                    higherSections = session.query(query);
                    log.warn((Object)higherSections.size());
                    latestPublicationsMap = this.getLatestPublicationMap(session, higherSections);
                    this.ctx.setProperty("latestPublicationsMap", (Object)latestPublicationsMap);
                    this.ctx.setProperty("higherSections", (Object)higherSections);
                }
            }
            catch (ClientException e) {
                log.error((Object)e);
            }
        }
    }

    protected HashMap getLatestPublicationMap(CoreSession session, DocumentModelList higherSections) throws ClientException {
        HashMap<String, DocumentModelList> latestPublicationsMap = new HashMap<String, DocumentModelList>();
        if (!higherSections.isEmpty()) {
            for (DocumentModel higherSection : higherSections) {
                String query = "select * from Document where ecm:primaryType!='Section' and ecm:path startswith '" + higherSection.getPathAsString() + "' order by dc:issued desc";
                DocumentModelList sectionChildren = session.query(query, 3);
                latestPublicationsMap.put(higherSection.getId(), sectionChildren);
            }
        }
        return latestPublicationsMap;
    }

    public String getSearchPattern() {
        return this.searchPattern;
    }

    public void setSearchPattern(String searchPattern) {
        this.searchPattern = searchPattern;
    }

    @POST
    @Path(value="search")
    @Produces(value={"text/html"})
    public Object searchNotes() {
        FormData data = this.ctx.getForm();
        this.searchPattern = (String)data.get("searchPattern")[0];
        CoreSession session = this.ctx.getCoreSession();
        String query = "select * from Document where ecm:currentLifeCycleState != 'deleted' and ecm:primaryType!='Section' and ecm:isProxy=1 and ecm:fulltext='" + this.searchPattern + "'";
        log.warn((Object)query);
        DocumentModelList searchResult = null;
        try {
            searchResult = session.query(query);
        }
        catch (ClientException e) {
            log.error((Object)e);
        }
        this.ctx.setProperty("searchResult", (Object)searchResult);
        return this.getView("search");
    }

    public String getDownloadURL(DocumentModel doc) throws ClientException {
        if (doc == null) {
            return null;
        }
        String filename = (String)((Object)doc.getPropertyValue("file:filename"));
        String downloadURL = this.getNuxeoContextPath() + "/";
        downloadURL = downloadURL + "nxbigfile/";
        downloadURL = downloadURL + doc.getRepositoryName() + "/";
        downloadURL = downloadURL + doc.getRef().toString() + "/";
        downloadURL = downloadURL + "blobholder:0/";
        downloadURL = downloadURL + filename;
        return downloadURL;
    }

    private String getNuxeoContextPath() {
        if (this.nuxeoContextPath == null) {
            this.nuxeoContextPath = Framework.getProperty((String)"org.nuxeo.ecm.contextPath");
        }
        return this.nuxeoContextPath;
    }

    @GET
    @Path(value="about")
    @Produces(value={"text/html"})
    public Object getAbout() {
        return this.getView("about");
    }
}

