/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.net.SocketAppender;
import org.apache.log4j.spi.LoggingEvent;

public class StringifiedSocketAppender
extends SocketAppender {
    private static final int RESET_FREQUENCY = 1;

    public void append(LoggingEvent event) {
        if (event == null) {
            return;
        }
        if (this.address == null) {
            this.errorHandler.error("No remote host is set for SocketAppender named \"" + this.name + "\".");
            return;
        }
        if (this.oos != null) {
            try {
                if (this.locationInfo) {
                    event.getLocationInformation();
                }
                Set set = event.getProperties().entrySet();
                for (Map.Entry entry : set) {
                    event.setProperty((String)entry.getKey(), entry.getValue().toString());
                }
                if (this.getApplication() != null) {
                    event.setProperty("application", this.getApplication());
                }
                this.oos.writeObject(event);
                this.oos.flush();
                if (++this.counter >= 1) {
                    this.counter = 0;
                    this.oos.reset();
                }
            }
            catch (IOException e) {
                if (e instanceof InterruptedIOException) {
                    Thread.currentThread().interrupt();
                }
                this.oos = null;
                LogLog.warn((String)("Detected problem with connection: " + e));
                if (this.reconnectionDelay > 0) {
                    this.fireConnector();
                }
                this.errorHandler.error("Detected problem with connection, not reconnecting.", (Exception)e, 0);
            }
        }
    }
}

