/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.tomcat;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.apache.catalina.Container;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardHost;
import org.nuxeo.osgi.application.FrameworkBootstrap;

public class NuxeoDeployer
implements LifecycleListener {
    protected String home = "nxserver";
    protected FrameworkBootstrap bootstrap;

    public void setHome(String home) {
        this.home = home;
    }

    public String getHome() {
        return this.home;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        Lifecycle lifecycle = event.getLifecycle();
        String type = event.getType();
        if (lifecycle instanceof Container && "before_start".equals(type)) {
            Container container = (Container)lifecycle;
            this.preprocess(container);
        } else if (lifecycle instanceof StandardHost && "after_start".equals(type)) {
            StandardHost container = (StandardHost)lifecycle;
            this.checkFailures(container);
        }
    }

    protected void checkFailures(StandardHost host) {
        boolean ok = Stream.of(host.findChildren()).map(Lifecycle::getState).allMatch(s -> s == LifecycleState.STARTED);
        boolean strict = Boolean.getBoolean("nuxeo.start.strict");
        if (!ok && strict) {
            throw new IllegalStateException("Some contexts failed to start.");
        }
    }

    protected void preprocess(Container container) {
        try {
            ClassLoader parentCl = container.getParentClassLoader();
            File homeDir = this.resolveHomeDirectory();
            File bundles = new File(homeDir, "bundles");
            File lib = new File(homeDir, "lib");
            File deployerJar = FrameworkBootstrap.findFileStartingWidth((File)bundles, (String)"nuxeo-runtime-deploy");
            File commonJar = FrameworkBootstrap.findFileStartingWidth((File)bundles, (String)"nuxeo-common");
            if (deployerJar == null || commonJar == null) {
                System.out.println("Deployer and/or common JAR (nuxeo-runtime-deploy* | nuxeo-common*) not found in " + bundles);
                return;
            }
            ArrayList<URL> urls = new ArrayList<URL>();
            PathMatcher jar = FileSystems.getDefault().getPathMatcher("glob:**.jar");
            try (Stream<Path> stream = Files.list(lib.toPath());){
                stream.filter(jar::matches).map(this::toURL).forEach(urls::add);
            }
            stream = Files.list(bundles.toPath());
            try {
                stream.filter(jar::matches).map(this::toURL).forEach(urls::add);
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
            urls.add(homeDir.toURI().toURL());
            urls.add(new File(homeDir, "config").toURI().toURL());
            try (URLClassLoader cl = new URLClassLoader(urls.toArray(new URL[0]), parentCl);){
                System.out.println("# Running Nuxeo Preprocessor ...");
                Class<?> klass = cl.loadClass("org.nuxeo.runtime.deployment.preprocessor.DeploymentPreprocessor");
                Method main = klass.getMethod("main", String[].class);
                main.invoke(null, new Object[]{new String[]{homeDir.getAbsolutePath()}});
                System.out.println("# Preprocessing done.");
            }
        }
        catch (IOException | IllegalStateException | ReflectiveOperationException e) {
            throw new RuntimeException("Failed to handle event", e);
        }
    }

    protected URL toURL(Path p) {
        try {
            return p.toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }

    protected File resolveHomeDirectory() {
        Object path = this.home.startsWith("/") ? this.home : this.getTomcatHome() + "/" + this.home;
        return new File((String)path);
    }

    public String getTomcatHome() {
        String tomcatHome = System.getProperty("catalina.base");
        if (tomcatHome == null) {
            tomcatHome = System.getProperty("catalina.home");
        }
        return tomcatHome;
    }

    @Deprecated
    protected void handleEvent(ContainerBase container, LifecycleEvent event) {
        if ("before_start".equals(event.getType())) {
            this.preprocess((Container)container);
        }
    }
}

