/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.tomcat.dev;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class IOUtils {
    public static void deleteTree(File dir) {
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                IOUtils.deleteTree(file);
                continue;
            }
            file.delete();
        }
        dir.delete();
    }

    public static void copyTree(File source, File target) throws IOException {
        if (source.isDirectory()) {
            if (!target.exists()) {
                target.mkdir();
            }
            for (File child : source.listFiles()) {
                IOUtils.copyTree(child, new File(target, child.getName()));
            }
        } else {
            try (FileInputStream in = new FileInputStream(source);
                 FileOutputStream out = new FileOutputStream(target);){
                IOUtils.copyContent(in, out);
            }
        }
    }

    public static void copyContent(InputStream is, OutputStream out) throws IOException {
        int data;
        while (is.available() > 0 && (data = is.read()) != -1) {
            out.write(data);
        }
    }

    public static void appendResourceBundleFragments(String name, List<File> files, File target) throws IOException {
        FileOutputStream out;
        FileInputStream in;
        File l10n = new File(target, name);
        File backup = new File(target, name + "~bak");
        if (!backup.exists()) {
            backup.createNewFile();
            in = new FileInputStream(l10n);
            try {
                out = new FileOutputStream(backup);
                try {
                    IOUtils.copyContent(in, out);
                }
                finally {
                    out.close();
                }
            }
            finally {
                in.close();
            }
        }
        in = new FileInputStream(backup);
        try {
            out = new FileOutputStream(l10n);
            try {
                IOUtils.copyContent(in, out);
            }
            finally {
                out.close();
            }
        }
        finally {
            in.close();
        }
        for (File file : files) {
            try (FileInputStream in2 = new FileInputStream(file);
                 FileOutputStream out2 = new FileOutputStream(l10n, true);){
                IOUtils.copyContent(in2, out2);
            }
        }
    }
}

