/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.tomcat.dev;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.nuxeo.runtime.tomcat.dev.DevBundle;
import org.nuxeo.runtime.tomcat.dev.DevBundleType;

public class ReloadServiceInvoker {
    protected Object reloadService;
    protected Method deployBundles;
    protected Method undeployBundles;
    protected Method runDeploymentPreprocessor;
    @Deprecated
    protected Method installWebResources;
    protected Method flush;
    protected Method reload;
    protected Method flushSeam;
    protected Method reloadSeam;
    protected Object devReloadBridge;
    protected Method reloadBundles;
    protected Method getOSGIBundleName;

    public ReloadServiceInvoker(ClassLoader cl) throws ReflectiveOperationException {
        Class<?> frameworkClass = cl.loadClass("org.nuxeo.runtime.api.Framework");
        Class<?> reloadServiceClass = cl.loadClass("org.nuxeo.runtime.reload.ReloadService");
        Method getLocalService = frameworkClass.getDeclaredMethod("getLocalService", Class.class);
        this.reloadService = getLocalService.invoke(null, reloadServiceClass);
        this.deployBundles = reloadServiceClass.getDeclaredMethod("deployBundles", List.class);
        this.undeployBundles = reloadServiceClass.getDeclaredMethod("undeployBundles", List.class);
        this.runDeploymentPreprocessor = reloadServiceClass.getDeclaredMethod("runDeploymentPreprocessor", new Class[0]);
        this.installWebResources = reloadServiceClass.getDeclaredMethod("installWebResources", File.class);
        this.flush = reloadServiceClass.getDeclaredMethod("flush", new Class[0]);
        this.reload = reloadServiceClass.getDeclaredMethod("reload", new Class[0]);
        this.flushSeam = reloadServiceClass.getDeclaredMethod("flushSeamComponents", new Class[0]);
        this.reloadSeam = reloadServiceClass.getDeclaredMethod("reloadSeamComponents", new Class[0]);
        this.getOSGIBundleName = reloadServiceClass.getDeclaredMethod("getOSGIBundleName", File.class);
        Class<?> devReloadBridgeClass = cl.loadClass("org.nuxeo.runtime.reload.DevReloadBridge");
        this.devReloadBridge = devReloadBridgeClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        this.reloadBundles = devReloadBridgeClass.getDeclaredMethod("reloadBundles", List.class, List.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void hotDeployBundles(DevBundle[] bundles) throws ReflectiveOperationException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.reloadService.getClass().getClassLoader());
            this.flush();
            boolean hasSeam = false;
            ArrayList<File> files = new ArrayList<File>(bundles.length);
            for (DevBundle bundle : bundles) {
                if (bundle.getDevBundleType() == DevBundleType.Bundle) {
                    File file = bundle.file();
                    bundle.name = this.getOSGIBundleName(file);
                    files.add(file);
                    continue;
                }
                hasSeam = hasSeam || bundle.getDevBundleType() == DevBundleType.Seam;
            }
            this.deployBundles(files);
            for (File file : files) {
                this.installWebResources(file);
            }
            if (hasSeam) {
                this.reloadSeam();
            }
            this.reload();
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void hotUndeployBundles(DevBundle[] bundles) throws ReflectiveOperationException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.reloadService.getClass().getClassLoader());
            List<String> bundleNames = Stream.of(bundles).filter(bundle -> bundle.devBundleType == DevBundleType.Bundle).map(DevBundle::getName).filter(Objects::nonNull).collect(Collectors.toList());
            this.undeployBundles(bundleNames);
            if (Stream.of(bundles).map(DevBundle::getDevBundleType).anyMatch(DevBundleType.Seam::equals)) {
                this.flushSeam();
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DevBundle[] hotReloadBundles(DevBundle[] devBundlesToUndeploy, DevBundle[] devBundlesToDeploy) throws ReflectiveOperationException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.reloadService.getClass().getClassLoader());
            this.flush();
            List<String> bundlesNamesToUndeploy = Stream.of(devBundlesToUndeploy).filter(bundle -> bundle.devBundleType == DevBundleType.Bundle).map(DevBundle::getName).filter(Objects::nonNull).collect(Collectors.toList());
            ArrayList<File> bundlesToDeploy = new ArrayList<File>(devBundlesToDeploy.length);
            for (DevBundle bundle2 : devBundlesToDeploy) {
                if (bundle2.getDevBundleType() != DevBundleType.Bundle) continue;
                File file = bundle2.file();
                bundle2.name = this.getOSGIBundleName(file);
                bundlesToDeploy.add(file);
            }
            Map<String, String> deployedBundles = this.reloadBundles(bundlesNamesToUndeploy, bundlesToDeploy);
            DevBundle[] devBundleArray = (DevBundle[])deployedBundles.entrySet().stream().map(entry -> {
                DevBundle devBundle = new DevBundle((String)entry.getValue(), DevBundleType.Bundle);
                devBundle.name = (String)entry.getKey();
                return devBundle;
            }).toArray(DevBundle[]::new);
            return devBundleArray;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    @Deprecated
    protected void deployBundles(List<File> files) throws ReflectiveOperationException {
        this.deployBundles.invoke(this.reloadService, files);
    }

    @Deprecated
    protected void undeployBundles(List<String> bundleNames) throws ReflectiveOperationException {
        this.undeployBundles.invoke(this.reloadService, bundleNames);
    }

    protected void flush() throws ReflectiveOperationException {
        this.flush.invoke(this.reloadService, new Object[0]);
    }

    protected void flushSeam() throws ReflectiveOperationException {
        this.flushSeam.invoke(this.reloadService, new Object[0]);
    }

    protected void reload() throws ReflectiveOperationException {
        this.reload.invoke(this.reloadService, new Object[0]);
    }

    protected void reloadSeam() throws ReflectiveOperationException {
        this.reloadSeam.invoke(this.reloadService, new Object[0]);
    }

    protected void runDeploymentPreprocessor() throws ReflectiveOperationException {
        this.runDeploymentPreprocessor.invoke(this.reloadService, new Object[0]);
    }

    protected String getOSGIBundleName(File file) throws ReflectiveOperationException {
        return (String)this.getOSGIBundleName.invoke(this.reloadService, file);
    }

    @Deprecated
    protected void installWebResources(File file) throws ReflectiveOperationException {
        this.installWebResources.invoke(this.reloadService, file);
    }

    protected Map<String, String> reloadBundles(List<String> bundlesToUndeploy, List<File> bundlesToDeploy) throws ReflectiveOperationException {
        return (Map)this.reloadBundles.invoke(this.devReloadBridge, bundlesToUndeploy, bundlesToDeploy);
    }
}

