/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.tomcat.dev;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.osgi.application.FrameworkBootstrap;
import org.nuxeo.osgi.application.MutableClassLoader;
import org.nuxeo.runtime.tomcat.dev.DevBundle;
import org.nuxeo.runtime.tomcat.dev.DevBundleType;
import org.nuxeo.runtime.tomcat.dev.DevBundlesManager;
import org.nuxeo.runtime.tomcat.dev.IOUtils;
import org.nuxeo.runtime.tomcat.dev.NuxeoDevWebappClassLoader;
import org.nuxeo.runtime.tomcat.dev.ReloadServiceInvoker;

public class DevFrameworkBootstrap
extends FrameworkBootstrap
implements DevBundlesManager {
    protected final Log log = LogFactory.getLog(DevFrameworkBootstrap.class);
    protected DevBundle[] devBundles;
    protected Timer bundlesCheck;
    protected long lastModified = 0L;
    protected ReloadServiceInvoker reloadServiceInvoker;
    protected File devBundlesFile;
    protected final File seamdev;
    protected final File webclasses;

    public DevFrameworkBootstrap(MutableClassLoader cl, File home) throws IOException {
        super(cl, home);
        this.devBundlesFile = new File(home, "dev.bundles");
        this.seamdev = new File(home, "nuxeo.war/WEB-INF/dev");
        this.webclasses = new File(home, "nuxeo.war/WEB-INF/classes");
    }

    public void start() throws ReflectiveOperationException, IOException {
        this.preloadDevBundles();
        super.start();
        this.reloadServiceInvoker = new ReloadServiceInvoker((ClassLoader)this.loader);
        this.writeComponentIndex();
        this.postloadDevBundles();
        String installReloadTimerOption = (String)this.env.get("org.nuxeo.app.installReloadTimer");
        if (installReloadTimerOption != null && Boolean.parseBoolean(installReloadTimerOption) == Boolean.TRUE) {
            this.toggleTimer();
        }
    }

    @Override
    public void toggleTimer() {
        if (this.bundlesCheck != null) {
            this.bundlesCheck.cancel();
            this.bundlesCheck = null;
        } else {
            this.bundlesCheck = new Timer("Dev Bundles Loader");
            this.bundlesCheck.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    DevFrameworkBootstrap.this.loadDevBundles();
                }
            }, 2000L, 2000L);
        }
    }

    @Override
    public boolean isTimerRunning() {
        return this.bundlesCheck != null;
    }

    public void stop() throws ReflectiveOperationException {
        if (this.bundlesCheck != null) {
            this.bundlesCheck.cancel();
            this.bundlesCheck = null;
        }
        super.stop();
    }

    @Override
    public String getDevBundlesLocation() {
        return this.devBundlesFile.getAbsolutePath();
    }

    protected void preloadDevBundles() throws IOException {
        if (!this.devBundlesFile.isFile()) {
            return;
        }
        this.lastModified = this.devBundlesFile.lastModified();
        this.devBundles = DevBundle.parseDevBundleLines(new FileInputStream(this.devBundlesFile));
        if (this.devBundles.length == 0) {
            this.devBundles = null;
            return;
        }
        this.installNewClassLoader(this.devBundles);
    }

    protected void postloadDevBundles() throws ReflectiveOperationException {
        if (this.devBundles != null) {
            this.reloadServiceInvoker.hotDeployBundles(this.devBundles);
        }
    }

    @Override
    public void loadDevBundles() {
        long tm = this.devBundlesFile.lastModified();
        if (this.lastModified >= tm) {
            return;
        }
        this.lastModified = tm;
        try {
            this.reloadDevBundles(DevBundle.parseDevBundleLines(new FileInputStream(this.devBundlesFile)));
        }
        catch (IOException | ReflectiveOperationException e) {
            this.log.error((Object)"Failed to deploy dev bundles", (Throwable)e);
        }
    }

    @Override
    public void resetDevBundles(String path) {
        this.devBundlesFile = new File(path);
        this.lastModified = 0L;
        this.loadDevBundles();
    }

    @Override
    public DevBundle[] getDevBundles() {
        return this.devBundles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void reloadDevBundles(DevBundle[] bundles) throws ReflectiveOperationException {
        if (this.devBundles != null) {
            try {
                this.reloadServiceInvoker.hotUndeployBundles(this.devBundles);
                this.clearClassLoader();
            }
            finally {
                this.devBundles = null;
            }
        }
        if (bundles != null) {
            try {
                this.installNewClassLoader(bundles);
                this.reloadServiceInvoker.hotDeployBundles(bundles);
            }
            finally {
                this.devBundles = bundles;
            }
        }
    }

    protected void clearClassLoader() {
        NuxeoDevWebappClassLoader devLoader = (NuxeoDevWebappClassLoader)this.loader;
        devLoader.clear();
        System.gc();
    }

    protected void installNewClassLoader(DevBundle[] bundles) {
        ArrayList<URL> jarUrls = new ArrayList<URL>();
        ArrayList<File> seamDirs = new ArrayList<File>();
        ArrayList<File> resourceBundleFragments = new ArrayList<File>();
        for (DevBundle bundle : bundles) {
            if (bundle.devBundleType.isJar) {
                try {
                    jarUrls.add(bundle.url());
                }
                catch (IOException e) {
                    this.log.error((Object)("Cannot install " + bundle));
                }
                continue;
            }
            if (bundle.devBundleType == DevBundleType.Seam) {
                seamDirs.add(bundle.file());
                continue;
            }
            if (bundle.devBundleType != DevBundleType.ResourceBundleFragment) continue;
            resourceBundleFragments.add(bundle.file());
        }
        NuxeoDevWebappClassLoader devLoader = (NuxeoDevWebappClassLoader)this.loader;
        devLoader.createLocalClassLoader(jarUrls.toArray(new URL[jarUrls.size()]));
        try {
            this.installSeamClasses(seamDirs.toArray(new File[seamDirs.size()]));
        }
        catch (IOException e) {
            this.log.error((Object)"Cannot install seam classes in hotsync folder", (Throwable)e);
        }
        try {
            this.installResourceBundleFragments(resourceBundleFragments);
        }
        catch (IOException e) {
            this.log.error((Object)"Cannot install l10n resources", (Throwable)e);
        }
    }

    public void writeComponentIndex() {
        File file = new File(this.home.getParentFile(), "sdk");
        file.mkdirs();
        file = new File(file, "components.index");
        try {
            Method m = this.getClassLoader().loadClass("org.nuxeo.runtime.model.impl.ComponentRegistrySerializer").getMethod("writeIndex", File.class);
            m.invoke(null, file);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
    }

    public void installSeamClasses(File[] dirs) throws IOException {
        if (this.seamdev.exists()) {
            IOUtils.deleteTree(this.seamdev);
        }
        this.seamdev.mkdirs();
        for (File dir : dirs) {
            IOUtils.copyTree(dir, this.seamdev);
        }
    }

    public void installResourceBundleFragments(List<File> files) throws IOException {
        HashMap fragments = new HashMap();
        for (File file : files) {
            String name = DevFrameworkBootstrap.resourceBundleName(file);
            if (!fragments.containsKey(name)) {
                fragments.put(name, new ArrayList());
            }
            ((List)fragments.get(name)).add(file);
        }
        for (String name : fragments.keySet()) {
            IOUtils.appendResourceBundleFragments(name, (List)fragments.get(name), this.webclasses);
        }
    }

    protected static String resourceBundleName(File file) {
        String name = file.getName();
        return name.substring(name.lastIndexOf(45) + 1);
    }
}

