/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.computation;

import java.util.Objects;

public final class Watermark
implements Comparable<Watermark> {
    public static final Watermark LOWEST = new Watermark(0L, 0, false);
    protected final long timestamp;
    protected final short sequence;
    protected final boolean completed;
    protected final long value;

    private Watermark(long timestamp, short sequence, boolean completed) {
        if (timestamp < 0L) {
            throw new IllegalArgumentException("timestamp must be positive");
        }
        this.timestamp = timestamp;
        this.sequence = sequence;
        this.completed = completed;
        this.value = timestamp << 17 | (long)((sequence & 0xFFFF) << 1) | (long)(completed ? 1 : 0);
    }

    public static Watermark ofValue(long watermarkValue) {
        if (watermarkValue < 0L) {
            throw new IllegalArgumentException("Watermark must be positive");
        }
        return new Watermark(watermarkValue >> 17, (short)(watermarkValue >> 1 & 0xFFFFL), (watermarkValue & 1L) == 1L);
    }

    public static Watermark ofNow() {
        return Watermark.ofTimestamp(System.currentTimeMillis(), (short)0);
    }

    public static Watermark ofTimestamp(long timestamp) {
        return Watermark.ofTimestamp(timestamp, (short)0);
    }

    public static Watermark ofTimestamp(long timestamp, short sequence) {
        return new Watermark(timestamp, sequence, false);
    }

    public static Watermark completedOf(Watermark watermark) {
        Objects.requireNonNull(watermark);
        return new Watermark(watermark.getTimestamp(), watermark.getSequence(), true);
    }

    public long getValue() {
        return this.value;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public short getSequence() {
        return this.sequence;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean isDone(long timestamp) {
        return Watermark.ofTimestamp(timestamp).compareTo(this) < 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Watermark watermark = (Watermark)o;
        return this.completed == watermark.completed && this.timestamp == watermark.timestamp && this.sequence == watermark.sequence;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public String toString() {
        return "Watermark{completed=" + this.completed + ", timestamp=" + this.timestamp + ", sequence=" + this.sequence + ", value=" + this.value + '}';
    }

    @Override
    public int compareTo(Watermark o) {
        if (o == null) {
            return Integer.MAX_VALUE;
        }
        long diff = this.value - o.value;
        int ret = (int)diff;
        if ((long)ret == diff) {
            return ret;
        }
        if (diff > 0L) {
            return Integer.MAX_VALUE;
        }
        return Integer.MIN_VALUE;
    }
}

