/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.computation.internals;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.nuxeo.lib.stream.computation.ComputationContext;
import org.nuxeo.lib.stream.computation.ComputationMetadataMapping;
import org.nuxeo.lib.stream.computation.Record;

public class ComputationContextImpl
implements ComputationContext {
    protected final ComputationMetadataMapping metadata;
    protected final Map<String, List<Record>> streamRecords;
    protected final Map<String, Long> timers;
    protected boolean checkpointFlag;
    protected long lowWatermark;
    protected boolean terminateFlag;

    public ComputationContextImpl(ComputationMetadataMapping metadata) {
        this.metadata = metadata;
        this.timers = new HashMap<String, Long>();
        this.streamRecords = new HashMap<String, List<Record>>();
    }

    public List<Record> getRecords(String streamName) {
        return this.streamRecords.getOrDefault(streamName, Collections.emptyList());
    }

    public Map<String, Long> getTimers() {
        return this.timers;
    }

    @Override
    public void setTimer(String key, long time) {
        Objects.requireNonNull(key);
        this.timers.put(key, time);
    }

    public void removeTimer(String key) {
        Objects.requireNonNull(key);
        this.timers.remove(key);
    }

    @Override
    public void produceRecord(String streamName, Record record) {
        String targetStream = this.metadata.map(streamName);
        if (!this.metadata.outputStreams().contains(targetStream)) {
            throw new IllegalArgumentException("Stream not registered as output: " + targetStream + ":" + streamName);
        }
        this.streamRecords.computeIfAbsent(targetStream, key -> new ArrayList()).add(record);
    }

    public long getSourceLowWatermark() {
        return this.lowWatermark;
    }

    @Override
    public void setSourceLowWatermark(long watermark) {
        this.lowWatermark = watermark;
    }

    public boolean requireCheckpoint() {
        return this.checkpointFlag;
    }

    public void removeCheckpointFlag() {
        this.checkpointFlag = false;
    }

    @Override
    public void askForCheckpoint() {
        this.checkpointFlag = true;
    }

    @Override
    public void askForTermination() {
        this.terminateFlag = true;
    }

    public boolean requireTerminate() {
        return this.terminateFlag;
    }
}

