/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.log;

import java.util.List;

public class LogLag {
    protected final long lowerOffset;
    protected final long upperOffset;
    protected final long lag;
    protected final long upper;

    public LogLag(long lowerOffset, long upperOffset) {
        this(lowerOffset, upperOffset, upperOffset - lowerOffset, upperOffset);
    }

    public LogLag(long lowerOffset, long upperOffset, long lag, long upper) {
        this.lowerOffset = lowerOffset;
        this.upperOffset = upperOffset;
        this.upper = upper;
        this.lag = lag;
    }

    public static LogLag of(long lowerOffset, long upperOffset) {
        return new LogLag(lowerOffset, upperOffset);
    }

    public static LogLag of(long lag) {
        return new LogLag(0L, lag, lag, lag);
    }

    public static LogLag of(List<LogLag> lags) {
        long[] end = new long[]{0L};
        long[] pos = new long[]{Long.MAX_VALUE};
        long[] lag = new long[]{0L};
        long[] endMessages = new long[]{0L};
        lags.forEach(item -> {
            if (item.lowerOffset() > 0L) {
                pos[0] = Math.min(pos[0], item.lowerOffset());
            }
            end[0] = Math.max(end[0], item.upperOffset());
            endMessages[0] = endMessages[0] + item.upper();
            lag[0] = lag[0] + item.lag();
        });
        return new LogLag(pos[0] == Long.MAX_VALUE ? 0L : pos[0], end[0], lag[0], endMessages[0]);
    }

    public long lag() {
        return this.lag;
    }

    public long upper() {
        return this.upper;
    }

    public long lower() {
        return this.upper - this.lag;
    }

    public long upperOffset() {
        return this.upperOffset;
    }

    public long lowerOffset() {
        return this.lowerOffset;
    }

    public String toString() {
        return "LogLag{lower=" + this.lower() + ", upper=" + this.upper + ", lag=" + this.lag + ", lowerOffset=" + this.lowerOffset + ", upperOffset=" + this.upperOffset + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogLag lag1 = (LogLag)o;
        return this.lag == lag1.lag;
    }

    public int hashCode() {
        return (int)(this.lag ^ this.lag >>> 32);
    }
}

