/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.log.kafka;

public class KafkaNamespace {
    protected final String prefix;
    protected final int prefixLen;

    public KafkaNamespace(String prefix) {
        this.prefix = prefix;
        this.prefixLen = prefix.length();
    }

    public String getTopicName(String logName) {
        return this.prefix + logName;
    }

    public String getLogName(String topicName) {
        if (!topicName.startsWith(this.prefix)) {
            throw new IllegalArgumentException(String.format("topic %s with invalid prefix %s", topicName, this.prefix));
        }
        return topicName.substring(this.prefixLen);
    }

    public String getKafkaGroup(String group) {
        return this.prefix + group;
    }

    public String getGroup(String kafkaGroup) {
        if (!kafkaGroup.startsWith(this.prefix)) {
            throw new IllegalArgumentException(String.format("group %s with invalid prefix %s", kafkaGroup, this.prefix));
        }
        return kafkaGroup.substring(this.prefixLen);
    }

    public String toString() {
        return "KafkaNamespace{prefix='" + this.prefix + '\'' + '}';
    }
}

