/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.tools;

import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.nuxeo.lib.stream.log.LogManager;
import org.nuxeo.lib.stream.log.chronicle.ChronicleLogManager;
import org.nuxeo.lib.stream.log.kafka.KafkaLogManager;
import org.nuxeo.lib.stream.tools.CommandRegistry;
import org.nuxeo.lib.stream.tools.KafkaConfigParser;
import org.nuxeo.lib.stream.tools.command.Command;
import org.nuxeo.lib.stream.tools.command.HelpCommand;

public class Main {
    protected static final String NUXEO_KAFKA_FILE_CONF = "nxserver/config/kafka-config.xml";
    protected static final String NUXEO_KAFKA_CONF = "default";
    protected final Map<String, Command> commandMap = new HashMap<String, Command>();
    protected final Options options = new Options();
    protected String command;
    protected LogManager manager;

    public static void main(String[] args) {
        boolean success = new Main().run(args);
        if (!success) {
            System.exit(-1);
        }
    }

    public boolean run(String[] args) {
        this.initDefaultOptions();
        if (args == null || args.length == 0 || args[0].trim().isEmpty()) {
            this.command = "help";
            return this.runWithArgs(null);
        }
        this.command = Objects.requireNonNull(args)[0];
        return this.runWithArgs(Arrays.copyOfRange(args, 1, args.length));
    }

    protected boolean runWithArgs(String[] args) {
        try {
            Command cmd = this.getCommand();
            cmd.updateOptions(this.options);
            DefaultParser parser = new DefaultParser();
            CommandLine cmdLine = parser.parse(this.options, args);
            this.createManager(cmd, cmdLine);
            return cmd.run(this.manager, cmdLine);
        }
        catch (ParseException e) {
            System.err.println("Parse error: " + e.getMessage() + ", try: help " + this.command);
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            System.err.println("Interrupted: " + e.getMessage());
        }
        return false;
    }

    protected void createManager(Command cmd, CommandLine cmdLine) {
        if (cmd instanceof HelpCommand) {
            return;
        }
        if (cmdLine.hasOption("chronicle")) {
            this.createChronicleManager(cmdLine.getOptionValue("chronicle"));
        } else if (cmdLine.hasOption("kafka") || cmdLine.hasOption("k")) {
            String contribPath = cmdLine.getOptionValue("kafka", NUXEO_KAFKA_FILE_CONF);
            this.createKafkaManager(contribPath, cmdLine.getOptionValue("kafka-config", NUXEO_KAFKA_CONF));
        } else {
            throw new IllegalArgumentException("Missing required option: --chronicle or --kafka");
        }
    }

    protected void createKafkaManager(String kafkaContribution, String kafkaConfig) {
        KafkaConfigParser config = new KafkaConfigParser(Paths.get(kafkaContribution, new String[0]), kafkaConfig);
        this.manager = new KafkaLogManager(config.getZkServers(), config.getPrefix(), config.getProducerProperties(), config.getConsumerProperties());
    }

    protected void createChronicleManager(String basePath) {
        this.manager = new ChronicleLogManager(Paths.get(basePath, new String[0]));
    }

    protected Command getCommand() {
        if (this.commandMap.isEmpty()) {
            new CommandRegistry().commands().forEach(cmd -> this.commandMap.put(cmd.name(), (Command)cmd));
        }
        if ("-h".equals(this.command) || "--help".equals(this.command)) {
            this.command = "help";
        } else if (!this.commandMap.containsKey(this.command)) {
            throw new IllegalArgumentException("Unknown command: " + this.command);
        }
        return this.commandMap.get(this.command);
    }

    protected void initDefaultOptions() {
        this.options.addOption(Option.builder().longOpt("chronicle").desc("Base path of the Chronicle Queue LogManager").hasArg().argName("PATH").build());
        this.options.addOption(Option.builder().longOpt("kafka").desc("Nuxeo Kafka configuration contribution file: nxserver/config/kafka-config.xml").hasArg().argName("PATH").build());
        this.options.addOption(Option.builder().longOpt("kafka-config").desc("Config name in the Nuxeo Kafka configuration contribution").hasArg().argName("CONFIG").build());
        this.options.addOption("k", "nuxeo-kafka", false, "Use the default Nuxeo Kafka configuration");
    }

    public LogManager getLogManager(String[] args) {
        this.run(args);
        return this.manager;
    }
}

