/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.tools.command;

import java.time.Duration;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.lib.stream.log.LogAppender;
import org.nuxeo.lib.stream.log.LogManager;
import org.nuxeo.lib.stream.log.LogRecord;
import org.nuxeo.lib.stream.log.LogTailer;
import org.nuxeo.lib.stream.tools.command.Command;

public class CopyCommand
extends Command {
    protected static final String NAME = "copy";

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void updateOptions(Options options) {
        options.addOption(Option.builder().longOpt("src").desc("Source log name").required().hasArg().argName("LOG_NAME").build());
        options.addOption(Option.builder().longOpt("dest").desc("Target log name").required().hasArg().argName("LOG_NAME").build());
        options.addOption(Option.builder((String)"g").longOpt("group").desc("Source consumer group to use").hasArg().argName("GROUP").build());
    }

    @Override
    public boolean run(LogManager manager, CommandLine cmd) throws InterruptedException {
        String src = cmd.getOptionValue("src");
        String dest = cmd.getOptionValue("dest");
        String group = cmd.getOptionValue("group", "tools");
        return this.copy(manager, src, dest, group);
    }

    protected boolean copy(LogManager manager, String src, String dest, String group) {
        System.out.println(String.format("# Copy %s to %s", src, dest));
        if (!manager.exists(src)) {
            System.err.println("source log not found: " + src);
            return false;
        }
        if (manager.exists(dest)) {
            System.err.println("destination log already exists: " + dest);
            return false;
        }
        manager.createIfNotExists(dest, manager.getAppender(src).size());
        LogAppender appender = manager.getAppender(dest);
        try (LogTailer tailer = manager.createTailer(group, src);){
            LogRecord record;
            while ((record = tailer.read(Duration.ofSeconds(5L))) != null) {
                appender.append(((Record)record.message()).key, record.message());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            System.err.println("Interrupted");
            return false;
        }
        return true;
    }
}

