/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.tools.command;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.nuxeo.lib.stream.log.LogLag;
import org.nuxeo.lib.stream.log.LogManager;
import org.nuxeo.lib.stream.tools.command.Command;

public class LagCommand
extends Command {
    protected static final String NAME = "lag";
    protected boolean verbose = false;

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void updateOptions(Options options) {
        options.addOption(Option.builder((String)"l").longOpt("log-name").desc("Log name").hasArg().argName("LOG_NAME").build());
        options.addOption(Option.builder().longOpt("verbose").desc("Display lag for each partition").build());
    }

    @Override
    public boolean run(LogManager manager, CommandLine cmd) throws InterruptedException {
        String name = cmd.getOptionValue("log-name");
        this.verbose = cmd.hasOption("verbose");
        if (name != null) {
            this.lag(manager, name);
        } else {
            this.lag(manager);
        }
        return true;
    }

    protected void lag(LogManager manager) {
        System.out.println("# " + manager);
        for (String name : manager.listAll()) {
            this.lag(manager, name);
        }
    }

    protected void lag(LogManager manager, String name) {
        System.out.println("## Log: " + name + " partitions: " + manager.getAppender(name).size());
        List<String> consumers = manager.listConsumerGroups(name);
        if (this.verbose && consumers.isEmpty()) {
            consumers.add("tools");
        }
        consumers.forEach(group -> this.renderLag((String)group, manager.getLagPerPartition(name, (String)group)));
    }

    protected void renderLag(String group, List<LogLag> lags) {
        System.out.println("### Group: " + group);
        System.out.println("| partition | lag | pos | end | posOffset |\u00a0endOffset\u00a0|\n| --- | ---: | ---: | ---: | ---: |");
        LogLag all = LogLag.of(lags);
        System.out.println(String.format("|All|%d|%d|%d|%d|%d|", all.lag(), all.lower(), all.upper(), all.lowerOffset(), all.upperOffset()));
        if (this.verbose && lags.size() > 1) {
            AtomicInteger i = new AtomicInteger();
            lags.forEach(lag -> System.out.println(String.format("|%s|%d|%d|%d|%d|%d|", i.getAndIncrement(), lag.lag(), lag.lower(), lag.upper(), lag.lowerOffset(), lag.upperOffset())));
        }
    }
}

