/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.tools.command;

import java.time.Instant;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.nuxeo.lib.stream.computation.Watermark;
import org.nuxeo.lib.stream.log.Latency;
import org.nuxeo.lib.stream.log.LogManager;
import org.nuxeo.lib.stream.tools.command.Command;

public class LatencyCommand
extends Command {
    protected static final String NAME = "latency";
    protected boolean verbose = false;

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void updateOptions(Options options) {
        options.addOption(Option.builder((String)"l").longOpt("log-name").desc("Log name of a stream containing computation.Record").hasArg().argName("LOG_NAME").build());
        options.addOption(Option.builder().longOpt("verbose").desc("Display latency for each partition").build());
    }

    @Override
    public boolean run(LogManager manager, CommandLine cmd) {
        String name = cmd.getOptionValue("log-name");
        this.verbose = cmd.hasOption("verbose");
        if (name != null) {
            this.latency(manager, name);
        } else {
            this.latency(manager);
        }
        return true;
    }

    protected void latency(LogManager manager) {
        System.out.println("# " + manager);
        for (String name : manager.listAll()) {
            this.latency(manager, name);
        }
    }

    protected void latency(LogManager manager, String name) {
        System.out.println("## Log: " + name + " partitions: " + manager.getAppender(name).size());
        List<String> consumers = manager.listConsumerGroups(name);
        if (this.verbose && consumers.isEmpty()) {
            consumers.add("tools");
        }
        try {
            consumers.forEach(group -> this.renderLatency((String)group, manager.getLatencyPerPartition(name, (String)group, rec -> Watermark.ofValue(rec.watermark).getTimestamp(), rec -> rec.key)));
        }
        catch (IllegalStateException e) {
            System.err.println(e.getMessage());
        }
    }

    protected void renderLatency(String group, List<Latency> latencies) {
        System.out.println(String.format("### Group: %s", group));
        System.out.println("| partition | lag | latencyMs | latency | posTimestamp | posDate | curDate | pos | end | posOffset |\u00a0endOffset\u00a0| posKey |\n| --- | ---: | ---: | ---: | ---: | ---: | ---: | ---: | ---: | ---: | ---: | --- |");
        Latency all = Latency.of(latencies);
        System.out.println(String.format("|All|%d|%d|%s|%d|%s|%s|%d|%d|%d|%d|%s|", all.lag().lag(), all.latency(), LatencyCommand.formatInterval(all.latency()), all.lower(), this.formatDate(all.lower()), this.formatDate(all.upper()), all.lag().lower(), all.lag().upper(), all.lag().lowerOffset(), all.lag().upperOffset(), all.key()));
        if (this.verbose && latencies.size() > 1) {
            AtomicInteger i = new AtomicInteger();
            latencies.forEach(lat -> System.out.println(String.format("|%d|%d|%d|%s|%d|%s|%s|%d|%d|%d|%d|%s|", i.getAndIncrement(), lat.lag().lag(), lat.latency(), LatencyCommand.formatInterval(lat.latency()), lat.lower(), this.formatDate(lat.lower()), this.formatDate(lat.upper()), lat.lag().lower(), lat.lag().upper(), lat.lag().lowerOffset(), lat.lag().upperOffset(), lat.key())));
        }
    }

    protected String formatDate(long timestamp) {
        if (timestamp > 0L) {
            return Instant.ofEpochMilli(timestamp).toString();
        }
        return "NA";
    }

    protected static String formatInterval(long l) {
        if (l == 0L) {
            return "NA";
        }
        long hr = TimeUnit.MILLISECONDS.toHours(l);
        long min = TimeUnit.MILLISECONDS.toMinutes(l - TimeUnit.HOURS.toMillis(hr));
        long sec = TimeUnit.MILLISECONDS.toSeconds(l - TimeUnit.HOURS.toMillis(hr) - TimeUnit.MINUTES.toMillis(min));
        long ms = TimeUnit.MILLISECONDS.toMillis(l - TimeUnit.HOURS.toMillis(hr) - TimeUnit.MINUTES.toMillis(min) - TimeUnit.SECONDS.toMillis(sec));
        return String.format("%02d:%02d:%02d.%03d", hr, min, sec, ms);
    }
}

