/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.computation;

import java.time.Duration;
import net.jodah.failsafe.RetryPolicy;
import org.nuxeo.lib.stream.computation.ComputationPolicyBuilder;

public class ComputationPolicy {
    public static final RetryPolicy NO_RETRY = new RetryPolicy().withMaxRetries(0);
    protected final RetryPolicy retryPolicy;
    protected final int batchCapacity;
    protected final Duration batchThreshold;
    protected final boolean skipFailure;

    public ComputationPolicy(ComputationPolicyBuilder builder) {
        this.batchCapacity = builder.batchCapacity;
        this.batchThreshold = builder.batchThreshold;
        this.skipFailure = builder.skipFailure;
        this.retryPolicy = builder.retryPolicy;
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public int getBatchCapacity() {
        return this.batchCapacity;
    }

    public Duration getBatchThreshold() {
        return this.batchThreshold;
    }

    public boolean isSkipFailure() {
        return this.skipFailure;
    }

    public String toString() {
        return "ComputationPolicy{retryMax=" + this.retryPolicy.getMaxRetries() + ", retryDelay=" + this.retryPolicy.getDelay() + ", batchCapacity=" + this.batchCapacity + ", batchThreshold=" + this.batchThreshold + ", skipFailure=" + this.skipFailure + '}';
    }
}

