/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.computation;

import java.time.Duration;
import net.jodah.failsafe.RetryPolicy;
import org.nuxeo.lib.stream.computation.ComputationPolicy;

public class ComputationPolicyBuilder {
    protected static final int DEFAULT_BATCH_CAPACITY = 10;
    protected static final int DEFAULT_BATCH_THRESHOLD_SECOND = 1;
    protected RetryPolicy retryPolicy = ComputationPolicy.NO_RETRY;
    protected boolean skipFailure = false;
    protected int batchCapacity = 10;
    protected Duration batchThreshold = Duration.ofSeconds(1L);

    public ComputationPolicyBuilder batchPolicy(int capacity, Duration timeThreshold) {
        this.batchCapacity = capacity;
        this.batchThreshold = timeThreshold;
        return this;
    }

    public ComputationPolicyBuilder retryPolicy(RetryPolicy policy) {
        this.retryPolicy = policy;
        return this;
    }

    public ComputationPolicyBuilder continueOnFailure(boolean value) {
        this.skipFailure = value;
        return this;
    }

    public ComputationPolicy build() {
        return new ComputationPolicy(this);
    }
}

