/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.computation;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Objects;
import org.nuxeo.lib.stream.computation.Watermark;

public class Record
implements Externalizable {
    protected static final EnumSet<Flag> DEFAULT_FLAG = EnumSet.of(Flag.DEFAULT);
    protected static final byte[] NO_DATA = new byte[0];
    static final long serialVersionUID = 20170529L;
    @Deprecated
    public long watermark;
    @Deprecated
    public String key;
    @Deprecated
    public byte[] data = NO_DATA;
    @Deprecated
    public transient EnumSet<Flag> flags;
    protected byte flagsAsByte;

    public Record() {
    }

    public Record(String key, byte[] data) {
        this(key, data, Watermark.ofNow().getValue(), DEFAULT_FLAG);
    }

    public Record(String key, byte[] data, long watermark) {
        this(key, data, watermark, DEFAULT_FLAG);
    }

    public Record(String key, byte[] data, long watermark, EnumSet<Flag> flags) {
        this.key = key;
        this.watermark = watermark;
        this.setData(data);
        this.setFlags(flags);
    }

    public static Record of(String key, byte[] data) {
        return new Record(key, data);
    }

    public long getWatermark() {
        return this.watermark;
    }

    public void setWatermark(long watermark) {
        this.watermark = watermark;
    }

    public EnumSet<Flag> getFlags() {
        if (this.flags == null) {
            this.flags = this.decodeFlags(this.flagsAsByte);
        }
        return this.flags;
    }

    public void setFlags(EnumSet<Flag> flags) {
        this.flags = flags;
        this.flagsAsByte = (byte)this.encodeFlags(flags);
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data != null ? data : NO_DATA;
    }

    public String toString() {
        String overview = "";
        String wmDate = "";
        if (this.data != null && this.data.length > 0) {
            overview = ", data=\"" + new String(this.data, StandardCharsets.UTF_8).substring(0, Math.min(this.data.length, 127)) + '\"';
            overview = overview.replaceAll("[^\\x20-\\x7e]", ".");
        }
        if (this.watermark > 0L) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            Watermark wm = Watermark.ofValue(this.watermark);
            wmDate = ", wmDate=" + dateFormat.format(new Date(wm.getTimestamp()));
        }
        return "Record{watermark=" + this.watermark + wmDate + ", flags=" + this.getFlags() + ", key='" + this.key + '\'' + ", data.length=" + (this.data == null ? 0 : this.data.length) + overview + '}';
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.watermark);
        out.writeShort(this.flagsAsByte);
        out.writeObject(this.key);
        if (this.data == null || this.data.length == 0) {
            out.writeInt(0);
        } else {
            out.writeInt(this.data.length);
            out.write(this.data);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.watermark = in.readLong();
        this.flagsAsByte = (byte)in.readShort();
        this.key = (String)in.readObject();
        int dataLength = in.readInt();
        if (dataLength == 0) {
            this.data = NO_DATA;
        } else {
            int byteRead;
            this.data = new byte[dataLength];
            for (int pos = 0; pos < dataLength; pos += byteRead) {
                byteRead = in.read(this.data, pos, dataLength - pos);
                if (byteRead != -1) continue;
                throw new IllegalStateException("Corrupted stream, can not read " + dataLength + " bytes");
            }
        }
    }

    protected short encodeFlags(EnumSet<Flag> enumSet) {
        short ret = 0;
        if (enumSet != null) {
            for (Flag val : enumSet) {
                ret = (short)(ret | 1 << val.ordinal());
            }
        }
        return ret;
    }

    protected EnumSet<Flag> decodeFlags(byte encoded) {
        HashMap<Integer, Flag> ordinalMap = new HashMap<Integer, Flag>();
        for (Flag val : Flag.ALL_OPTS) {
            ordinalMap.put(val.ordinal(), val);
        }
        EnumSet<Flag> ret = EnumSet.noneOf(Flag.class);
        int ordinal = 0;
        for (byte i = 1; i != 0; i = (byte)(i << 1)) {
            if ((i & encoded) != 0) {
                ret.add((Flag)((Object)ordinalMap.get(ordinal)));
            }
            ++ordinal;
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Record record = (Record)o;
        return this.watermark == record.watermark && this.flagsAsByte == record.flagsAsByte && Objects.equals(this.key, record.key) && Arrays.equals(this.data, record.data);
    }

    public int hashCode() {
        int result = Objects.hash(this.watermark, this.flagsAsByte, this.key);
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    public static enum Flag {
        DEFAULT,
        COMMIT,
        POISON_PILL,
        SKIP,
        TRACE,
        PAUSE,
        USER1,
        USER2;

        public static final EnumSet<Flag> ALL_OPTS;

        static {
            ALL_OPTS = EnumSet.allOf(Flag.class);
        }
    }
}

