/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.computation;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.lib.stream.codec.NoCodec;
import org.nuxeo.lib.stream.computation.Record;

public class Settings {
    protected final int defaultConcurrency;
    protected final int defaultPartitions;
    protected final Codec<Record> defaultCodec;
    protected final Map<String, Integer> concurrencies = new HashMap<String, Integer>();
    protected final Map<String, Integer> partitions = new HashMap<String, Integer>();
    protected final Map<String, Codec<Record>> codecs = new HashMap<String, Codec<Record>>();

    public Settings(int defaultConcurrency, int defaultPartitions) {
        this(defaultConcurrency, defaultPartitions, NoCodec.NO_CODEC);
    }

    public Settings(int defaultConcurrency, int defaultPartitions, Codec<Record> defaultCodec) {
        this.defaultConcurrency = defaultConcurrency;
        this.defaultPartitions = defaultPartitions;
        this.defaultCodec = defaultCodec == null ? NoCodec.NO_CODEC : defaultCodec;
    }

    public Settings setConcurrency(String computationName, int concurrency) {
        this.concurrencies.put(computationName, concurrency);
        return this;
    }

    public int getConcurrency(String computationName) {
        return this.concurrencies.getOrDefault(computationName, this.defaultConcurrency);
    }

    public Settings setPartitions(String streamName, int partitions) {
        this.partitions.put(streamName, partitions);
        return this;
    }

    public int getPartitions(String streamName) {
        return this.partitions.getOrDefault(streamName, this.defaultPartitions);
    }

    public Settings setCodec(String streamName, Codec<Record> codec) {
        Objects.requireNonNull(codec);
        this.codecs.put(streamName, codec);
        return this;
    }

    public Codec<Record> getCodec(String streamName) {
        return this.codecs.getOrDefault(streamName, this.defaultCodec);
    }
}

