/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.log.chronicle;

import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Stream;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.impl.StoreFileListener;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.lib.stream.codec.NoCodec;
import org.nuxeo.lib.stream.log.LogOffset;
import org.nuxeo.lib.stream.log.LogPartition;
import org.nuxeo.lib.stream.log.LogTailer;
import org.nuxeo.lib.stream.log.chronicle.ChronicleLogOffsetTracker;
import org.nuxeo.lib.stream.log.chronicle.ChronicleLogTailer;
import org.nuxeo.lib.stream.log.chronicle.ChronicleRetentionDuration;
import org.nuxeo.lib.stream.log.chronicle.ChronicleRetentionListener;
import org.nuxeo.lib.stream.log.internals.CloseableLogAppender;
import org.nuxeo.lib.stream.log.internals.LogOffsetImpl;

public class ChronicleLogAppender<M extends Externalizable>
implements CloseableLogAppender<M> {
    private static final Log log = LogFactory.getLog(ChronicleLogAppender.class);
    protected static final String PARTITION_PREFIX = "P-";
    protected static final String METADATA_FILE = "metadata.properties";
    protected static final int POLL_INTERVAL_MS = 100;
    protected static final int MAX_PARTITIONS = 100;
    public static final String MSG_KEY = "msg";
    public static final int CQ_BLOCK_SIZE = 0x400000;
    public static final String RETENTION_KEY = "retention";
    public static final String PARTITIONS_KEY = "partitions";
    public static final String BLOCK_SIZE_KEY = "blockSize";
    protected final List<ChronicleQueue> partitions;
    protected final int nbPartitions;
    protected final File basePath;
    protected final int blockSize;
    protected final String name;
    protected final ConcurrentLinkedQueue<ChronicleLogTailer<M>> tailers = new ConcurrentLinkedQueue();
    protected final ChronicleRetentionDuration retention;
    protected final Codec<M> codec;
    protected volatile boolean closed;

    protected ChronicleLogAppender(Codec<M> codec, File basePath, ChronicleRetentionDuration retention) {
        if (!ChronicleLogAppender.exists(basePath)) {
            throw new IllegalArgumentException("Cannot open Chronicle Queues, invalid path: " + basePath);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Opening: " + this.toString()));
        }
        Objects.requireNonNull(codec);
        this.codec = codec;
        this.basePath = basePath;
        this.name = basePath.getName();
        Path metadataPath = this.getMetadataPath();
        Properties metadata = metadataPath.toFile().exists() ? ChronicleLogAppender.readMetadata(this.getMetadataPath()) : this.guessMetadata(retention);
        ChronicleRetentionDuration storedRetention = new ChronicleRetentionDuration(metadata.getProperty(RETENTION_KEY));
        if (retention.disable()) {
            this.retention = ChronicleRetentionDuration.disableOf(storedRetention);
        } else if (retention.getRollCycle() == storedRetention.getRollCycle()) {
            this.retention = retention;
        } else {
            throw new IllegalArgumentException(String.format("Cannot open Log %s: expecting retention: %s got: %s", this.name, storedRetention, retention));
        }
        this.nbPartitions = Integer.parseInt(metadata.getProperty(PARTITIONS_KEY));
        this.blockSize = Integer.parseInt(metadata.getProperty(BLOCK_SIZE_KEY));
        this.partitions = new ArrayList<ChronicleQueue>(this.nbPartitions);
        this.initPartitions(false);
    }

    protected ChronicleLogAppender(Codec<M> codec, File basePath, int size, ChronicleRetentionDuration retention) {
        if (size <= 0) {
            throw new IllegalArgumentException("Number of partitions must be > 0");
        }
        if (size > 100) {
            throw new IllegalArgumentException(String.format("Cannot create more than: %d partitions for log: %s, requested: %d", 100, basePath, size));
        }
        if (ChronicleLogAppender.exists(basePath)) {
            throw new IllegalArgumentException("Cannot create Chronicle Queues, already exists: " + basePath);
        }
        if (!basePath.exists() && !basePath.mkdirs()) {
            throw new IllegalArgumentException("Invalid path to create Chronicle Queues: " + basePath);
        }
        Objects.requireNonNull(codec);
        this.nbPartitions = size;
        this.codec = codec;
        this.name = basePath.getName();
        this.basePath = basePath;
        this.retention = retention;
        this.partitions = new ArrayList<ChronicleQueue>(this.nbPartitions);
        this.blockSize = 0x400000;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating: " + this.toString()));
        }
        this.initPartitions(true);
        this.saveMetadata();
    }

    protected void initPartitions(boolean create) {
        for (int i = 0; i < this.nbPartitions; ++i) {
            Path partitionPath = Paths.get(this.getBasePath(), String.format("%s%02d", PARTITION_PREFIX, i));
            if (create) {
                try {
                    Files.createDirectories(partitionPath, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Cannot create directory: " + partitionPath.toAbsolutePath(), e);
                }
            }
            ChronicleRetentionListener listener = null;
            SingleChronicleQueueBuilder builder = SingleChronicleQueueBuilder.binary((Path)partitionPath).rollCycle(this.retention.getRollCycle()).blockSize(this.blockSize);
            if (!this.retention.disable()) {
                listener = new ChronicleRetentionListener(this.retention);
                builder.storeFileListener((StoreFileListener)listener);
            }
            SingleChronicleQueue queue = builder.build();
            this.partitions.add((ChronicleQueue)queue);
            if (listener == null) continue;
            listener.setQueue(queue);
        }
    }

    protected void saveMetadata() {
        Path metadata = this.getMetadataPath();
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("# Log created %s%n", Instant.now().toString()));
        builder.append(String.format("%s=%d%n", PARTITIONS_KEY, this.nbPartitions));
        builder.append(String.format("%s=%s%n", RETENTION_KEY, this.retention));
        builder.append(String.format("%s=%d%n", BLOCK_SIZE_KEY, this.blockSize));
        try {
            Files.write(metadata, builder.toString().getBytes(), StandardOpenOption.CREATE_NEW);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to create metadata file: " + metadata, e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Created Log: %s%n%s", this.name, builder.toString()), new Throwable("here"));
        }
    }

    protected Path getMetadataPath() {
        return this.basePath.toPath().resolve(METADATA_FILE);
    }

    protected static Properties readMetadata(Path file) {
        Properties props = new Properties();
        try (InputStream stream = Files.newInputStream(file, new OpenOption[0]);){
            props.load(stream);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot open Log metadata file: " + file, e);
        }
        return props;
    }

    protected Properties guessMetadata(ChronicleRetentionDuration retention) {
        Properties props = new Properties();
        props.setProperty(PARTITIONS_KEY, Integer.toString(ChronicleLogAppender.discoverPartitions(this.basePath.toPath())));
        props.setProperty(RETENTION_KEY, retention.getRetention());
        props.setProperty(BLOCK_SIZE_KEY, Integer.toString(0x400000));
        return props;
    }

    protected static boolean exists(File basePath) {
        return basePath.isDirectory() && basePath.list().length > 0;
    }

    public static <M extends Externalizable> ChronicleLogAppender<M> create(Codec<M> codec, File basePath, int size, ChronicleRetentionDuration retention) {
        return new ChronicleLogAppender<M>(codec, basePath, size, retention);
    }

    public static <M extends Externalizable> ChronicleLogAppender<M> create(Codec<M> codec, File basePath, int size) {
        return new ChronicleLogAppender<M>(codec, basePath, size, ChronicleRetentionDuration.NONE);
    }

    public static <M extends Externalizable> ChronicleLogAppender<M> open(Codec<M> codec, File basePath) {
        return new ChronicleLogAppender<M>(codec, basePath, ChronicleRetentionDuration.NONE);
    }

    public static <M extends Externalizable> ChronicleLogAppender<M> open(Codec<M> codec, File basePath, ChronicleRetentionDuration retention) {
        return new ChronicleLogAppender<M>(codec, basePath, retention);
    }

    public String getBasePath() {
        return this.basePath.getPath();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int size() {
        return this.nbPartitions;
    }

    @Override
    public LogOffset append(int partition, M message) {
        ExcerptAppender appender = this.partitions.get(partition).acquireAppender();
        if (NoCodec.NO_CODEC.equals(this.codec)) {
            appender.writeDocument(w -> w.write((CharSequence)MSG_KEY).object(message));
        } else {
            appender.writeDocument(w -> w.write().bytes(this.codec.encode(message)));
        }
        long offset = appender.lastIndexAppended();
        LogOffsetImpl ret = new LogOffsetImpl(this.name, partition, offset);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("append to %s, value: %s", ret, message));
        }
        return ret;
    }

    public LogTailer<M> createTailer(LogPartition partition, String group, Codec<M> codec) {
        return this.addTailer(new ChronicleLogTailer<M>(codec, this.basePath.toString(), this.partitions.get(partition.partition()).createTailer(), partition, group, this.retention));
    }

    public long endOffset(int partition) {
        return this.partitions.get(partition).createTailer().toEnd().index();
    }

    public long firstOffset(int partition) {
        long ret = this.partitions.get(partition).firstIndex();
        if (ret == Long.MAX_VALUE) {
            return 0L;
        }
        return ret;
    }

    public long countMessages(int partition, long lowerOffset, long upperOffset) {
        long ret;
        SingleChronicleQueue queue = (SingleChronicleQueue)this.partitions.get(partition);
        try {
            ret = queue.countExcerpts(lowerOffset, upperOffset);
        }
        catch (IllegalStateException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Missing low cycle file: " + lowerOffset + " for queue: " + queue + " " + e.getMessage()));
            }
            return 0L;
        }
        return ret;
    }

    protected LogTailer<M> addTailer(ChronicleLogTailer<M> tailer) {
        this.tailers.add(tailer);
        return tailer;
    }

    @Override
    public boolean waitFor(LogOffset offset, String group, Duration timeout) throws InterruptedException {
        boolean ret;
        long offsetPosition = offset.offset();
        int partition = offset.partition().partition();
        try (ChronicleLogOffsetTracker offsetTracker = new ChronicleLogOffsetTracker(this.basePath.toString(), partition, group, ChronicleRetentionDuration.disableOf(this.retention));){
            ret = this.isProcessed(offsetTracker, offsetPosition);
            if (ret) {
                boolean bl = true;
                return bl;
            }
            long timeoutMs = timeout.toMillis();
            long deadline = System.currentTimeMillis() + timeoutMs;
            long delay = Math.min(100L, timeoutMs);
            while (!ret && System.currentTimeMillis() < deadline) {
                Thread.sleep(delay);
                ret = this.isProcessed(offsetTracker, offsetPosition);
            }
        }
        return ret;
    }

    @Override
    public boolean closed() {
        return this.closed;
    }

    @Override
    public Codec<M> getCodec() {
        return this.codec;
    }

    protected boolean isProcessed(ChronicleLogOffsetTracker tracker, long offset) {
        long last = tracker.readLastCommittedOffset();
        return last > 0L && last >= offset;
    }

    @Override
    public void close() {
        log.debug((Object)("Closing: " + this.toString()));
        this.tailers.stream().filter(Objects::nonNull).forEach(ChronicleLogTailer::close);
        this.tailers.clear();
        this.partitions.stream().filter(Objects::nonNull).forEach(Closeable::close);
        this.partitions.clear();
        this.closed = true;
    }

    public static int partitions(Path basePath) {
        Path metadataPath = basePath.resolve(METADATA_FILE);
        if (metadataPath.toFile().exists()) {
            return Integer.parseInt(ChronicleLogAppender.readMetadata(metadataPath).getProperty(PARTITIONS_KEY));
        }
        return ChronicleLogAppender.discoverPartitions(basePath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int discoverPartitions(Path basePath) {
        try (Stream<Path> paths = Files.list(basePath);){
            int ret = (int)paths.filter(ChronicleLogAppender::isPartitionDirectory).count();
            if (ret == 0) {
                throw new IOException("No chronicles queues file found");
            }
            int n = ret;
            return n;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid basePath for queue: " + basePath, e);
        }
    }

    protected static boolean isPartitionDirectory(Path path) {
        return path.toFile().isDirectory() && path.getFileName().toString().startsWith(PARTITION_PREFIX);
    }

    public String toString() {
        return "ChronicleLogAppender{nbPartitions=" + this.nbPartitions + ", basePath=" + this.basePath + ", name='" + this.name + '\'' + ", retention=" + this.retention + ", closed=" + this.closed + ", codec=" + this.codec + '}';
    }

    public ChronicleRetentionDuration getRetention() {
        return this.retention;
    }
}

