/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.tools.command;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.nuxeo.lib.stream.codec.AvroBinaryCodec;
import org.nuxeo.lib.stream.codec.AvroJsonCodec;
import org.nuxeo.lib.stream.codec.AvroMessageCodec;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.lib.stream.codec.NoCodec;
import org.nuxeo.lib.stream.codec.SerializableCodec;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.lib.stream.log.LogManager;
import org.nuxeo.lib.stream.tools.renderer.MarkdownRenderer;
import org.nuxeo.lib.stream.tools.renderer.Renderer;
import org.nuxeo.lib.stream.tools.renderer.TextRenderer;

public abstract class Command {
    public abstract String name();

    public abstract void updateOptions(Options var1);

    public abstract boolean run(LogManager var1, CommandLine var2) throws InterruptedException;

    protected Renderer getRecordRenderer(String render) {
        if ("markdown".equals(render)) {
            return new MarkdownRenderer();
        }
        return new TextRenderer();
    }

    protected Codec<Record> getRecordCodec(String codec) {
        if (codec == null) {
            return NoCodec.NO_CODEC;
        }
        switch (codec) {
            case "java": {
                return new SerializableCodec<Record>();
            }
            case "avro": {
                return new AvroMessageCodec<Record>(Record.class);
            }
            case "avroJson": {
                return new AvroJsonCodec<Record>(Record.class);
            }
            case "avroBinary": {
                return new AvroBinaryCodec<Record>(Record.class);
            }
        }
        throw new IllegalArgumentException("Unknown codec: " + codec);
    }
}

