/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.tools.command;

import java.time.Duration;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.lib.stream.log.LogManager;
import org.nuxeo.lib.stream.log.LogRecord;
import org.nuxeo.lib.stream.log.LogTailer;
import org.nuxeo.lib.stream.tools.command.Command;
import org.nuxeo.lib.stream.tools.renderer.Renderer;

public class TailCommand
extends Command {
    private static final Log log = LogFactory.getLog(TailCommand.class);
    protected static final String NAME = "tail";

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void updateOptions(Options options) {
        options.addOption(Option.builder((String)"n").longOpt("lines").desc("output the last NUM records").hasArg().argName("NUM").build());
        options.addOption("f", "follow", false, "output appended records");
        options.addOption(Option.builder((String)"l").longOpt("log-name").desc("Log name").required().hasArg().argName("LOG_NAME").build());
        options.addOption(Option.builder((String)"g").longOpt("group").desc("Consumer group").hasArg().argName("GROUP").build());
        options.addOption(Option.builder().longOpt("codec").desc("Codec used to read record, can be: java, avro, avroBinary, avroJson").hasArg().argName("CODEC").build());
        options.addOption(Option.builder().longOpt("render").desc("Output rendering").hasArg().argName("FORMAT").build());
        options.addOption(Option.builder((String)"t").longOpt("timeout").desc("Timeout on follow in second").hasArg().argName("TIMEOUT").build());
    }

    @Override
    public boolean run(LogManager manager, CommandLine cmd) throws InterruptedException {
        int lines = Integer.parseInt(cmd.getOptionValue("lines", "10"));
        String name = cmd.getOptionValue("log-name");
        String render = cmd.getOptionValue("render", "default");
        String group = cmd.getOptionValue("group", "tools");
        String codec = cmd.getOptionValue("codec");
        int timeout = Integer.parseInt(cmd.getOptionValue("timeout", "120"));
        this.tail(manager, name, group, lines, this.getRecordRenderer(render), codec);
        if (cmd.hasOption("follow")) {
            this.follow(manager, name, group, this.getRecordRenderer(render), timeout, codec);
        }
        return true;
    }

    protected void tail(LogManager manager, String name, String group, int lines, Renderer render, String codec) throws InterruptedException {
        LogRecord[] records = new LogRecord[lines];
        render.header();
        int count = 0;
        try (LogTailer<Record> tailer = manager.createTailer(group, name, this.getRecordCodec(codec));){
            LogRecord<Record> record;
            do {
                if ((record = tailer.read(Duration.ofMillis(500L))) == null) continue;
                records[count++ % lines] = record;
            } while (record != null);
        }
        for (int i = count; i < lines + count; ++i) {
            LogRecord record = records[i % lines];
            if (record == null) continue;
            render.accept(record);
        }
        render.footer();
    }

    protected void follow(LogManager manager, String name, String group, Renderer render, int timeout, String codec) throws InterruptedException {
        try (LogTailer<Record> tailer = manager.createTailer(group, name, this.getRecordCodec(codec));){
            tailer.toEnd();
            while (true) {
                LogRecord<Record> record;
                if ((record = tailer.read(Duration.ofSeconds(timeout))) == null) {
                    log.error((Object)"tail timeout");
                    break;
                }
                render.accept(record);
            }
        }
    }
}

