/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.tools.renderer;

import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.function.Consumer;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.lib.stream.computation.Watermark;
import org.nuxeo.lib.stream.log.LogRecord;

public abstract class Renderer
implements Consumer<LogRecord<Record>> {
    public abstract void header();

    public abstract void footer();

    protected String watermarkString(long watermark) {
        if (watermark == 0L) {
            return "0";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        Watermark wm = Watermark.ofValue(watermark);
        return String.format("%s:%d%s", dateFormat.format(new Date(wm.getTimestamp())), wm.getSequence(), wm.isCompleted() ? " completed" : "");
    }

    protected String binaryString(byte[] data) {
        String overview = "";
        if (data != null) {
            overview = overview + new String(data, StandardCharsets.UTF_8).substring(0, Math.min(data.length, 512));
            overview = overview.replaceAll("[^\\x20-\\x7e]", ".");
        }
        return overview;
    }
}

